/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.core.property_expression;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.event.Event;
import us.tlatoani.webskt.core.registration.DocumentationBuilder;
import us.tlatoani.webskt.core.registration.Registration;

public abstract class MundoPropertyExpression<F, T>
extends SimplePropertyExpression<F, T> {
    private static final Map<Class<? extends MundoPropertyExpression>, Info> infoMap = new HashMap<Class<? extends MundoPropertyExpression>, Info>();
    protected Info info = infoMap.get(((Object)((Object)this)).getClass());
    protected String property;

    public static <T> DocumentationBuilder.Expression registerPropertyExpression(Class<? extends Expression<T>> expressionClass, Class<T> type, String possessorType, String ... properties) {
        ArrayList<String> patternList = new ArrayList<String>(properties.length);
        ArrayList<String> propertyList = new ArrayList<String>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            if (property.contains("%")) {
                patternList.add(property.replace("%", "%" + possessorType + "%"));
                propertyList.add(property);
                continue;
            }
            patternList.add("[the] " + property + " of %" + possessorType + "%");
            patternList.add("%" + possessorType + "%'[s] " + property);
            propertyList.add(property);
            propertyList.add(property);
        }
        String[] patterns = patternList.toArray(new String[0]);
        Skript.registerExpression(expressionClass, type, (ExpressionType)ExpressionType.PROPERTY, (String[])patterns);
        if (MundoPropertyExpression.class.isAssignableFrom(expressionClass)) {
            MundoPropertyExpression.registerPropertyExpressionInfo(expressionClass, type, propertyList);
        }
        return (DocumentationBuilder.Expression)new DocumentationBuilder.Expression(Registration.getCurrentCategory(), patterns, type, expressionClass).requiredPlugins(Registration.getCurrentRequiredPlugins());
    }

    public static DocumentationBuilder.Condition registerPropertyExpressionCondition(Class<? extends Expression<Boolean>> expressionClass, String possessorType, String ... properties) {
        DocumentationBuilder.Expression exprDocBuilder = MundoPropertyExpression.registerPropertyExpression(expressionClass, Boolean.class, possessorType, properties);
        return (DocumentationBuilder.Condition)new DocumentationBuilder.Condition(Registration.getCurrentCategory(), exprDocBuilder.syntaxes, expressionClass).requiredPlugins(Registration.getCurrentRequiredPlugins());
    }

    private static void registerPropertyExpressionInfo(Class<? extends MundoPropertyExpression> exprClass, Class returnType, List<String> properties) {
        infoMap.put(exprClass, new Info(properties.toArray(new String[0]), returnType));
    }

    protected String getPropertyName() {
        return this.property;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.property = this.info.properties[i];
        return super.init(expressions, i, kleenean, parseResult);
    }

    public String toString(Event event, boolean debug) {
        if (this.property.contains("%")) {
            return this.property.replace("%", this.getExpr().toString(event, debug));
        }
        return "the " + this.property + " of " + this.getExpr().toString(event, debug);
    }

    public Class<? extends T> getReturnType() {
        return this.info.returnType;
    }

    public static class Info {
        public final String[] properties;
        public final Class returnType;

        public Info(String[] properties, Class returnType) {
            this.properties = properties;
            this.returnType = returnType;
        }
    }
}

