/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.core.base;

import java.util.concurrent.CountDownLatch;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import us.tlatoani.webskt.core.base.Logging;
import us.tlatoani.webskt.core.base.MundoAddon;

public class Scheduling {
    public static BukkitScheduler getScheduler() {
        return Bukkit.getScheduler();
    }

    public static void sync(Runnable runnable) {
        Scheduling.getScheduler().runTask((Plugin)MundoAddon.get(), runnable);
    }

    public static void async(Runnable runnable) {
        Scheduling.getScheduler().runTaskAsynchronously((Plugin)MundoAddon.get(), runnable);
    }

    public static void syncDelay(int ticks, Runnable runnable) {
        Scheduling.getScheduler().runTaskLater((Plugin)MundoAddon.get(), runnable, (long)ticks);
    }

    public static void asyncDelay(int ticks, Runnable runnable) {
        Scheduling.getScheduler().runTaskLaterAsynchronously((Plugin)MundoAddon.get(), runnable, (long)ticks);
    }

    public static void asyncLock(Runnable runnable) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Scheduling.sync(() -> {
            runnable.run();
            countDownLatch.countDown();
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Logging.reportException(runnable, e);
        }
    }
}

