/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.constructor;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.TriggerItem;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.event.Event;
import us.tlatoani.webskt.classes.WebSKTClient;
import us.tlatoani.webskt.core.base.Logging;
import us.tlatoani.webskt.core.event_scope.ScopeUtil;
import us.tlatoani.webskt.events.WebSocketClientConstructorEvent;
import us.tlatoani.webskt.java_websocket.WebSocket;
import us.tlatoani.webskt.mundosyntax.ExpressionConstraints;
import us.tlatoani.webskt.mundosyntax.SyntaxParser;
import us.tlatoani.webskt.mundosyntax.SyntaxPiece;
import us.tlatoani.webskt.mundosyntax.VariableCollective;
import us.tlatoani.webskt.mundosyntax.VariableUsage;
import us.tlatoani.webskt.template.WebSocketClientFunctionality;
import us.tlatoani.webskt.variables.VariablesMapManipulator;

public class WebSocketConstructor {
    public final SyntaxPiece syntax;
    public final WebSocketClientFunctionality functionality;
    public final String actualSyntax;
    public final String readableSyntax;
    private final VariableCollective variableCollective;
    private final Map<Integer, SyntaxPiece.MarkSpecificInformation> markSpecificInformationMap = new HashMap<Integer, SyntaxPiece.MarkSpecificInformation>();
    private final SectionNode sectionNode;
    private TriggerItem triggerItem = null;

    private WebSocketConstructor(SyntaxPiece syntax, WebSocketClientFunctionality functionality, SectionNode sectionNode) {
        this.syntax = syntax;
        this.actualSyntax = syntax.actualSyntax(0);
        this.readableSyntax = syntax.readableSyntax();
        this.variableCollective = syntax.getVariables();
        this.functionality = functionality;
        this.sectionNode = sectionNode;
    }

    public static Optional<WebSocketConstructor> from(String syntax, WebSocketClientFunctionality functionality, SectionNode sectionNode) {
        SyntaxPiece syntaxPiece;
        try {
            syntaxPiece = SyntaxParser.parse(syntax);
        }
        catch (IllegalArgumentException e) {
            Logging.debug(WebSocketConstructor.class, e);
            Skript.error((String)"Invalid constructor syntax!");
            return Optional.empty();
        }
        catch (Exception e) {
            Logging.reportException(WebSocketConstructor.class, e);
            Skript.error((String)"An error occurred while validating the constructor syntax");
            return Optional.empty();
        }
        WebSocketConstructor constructor = new WebSocketConstructor(syntaxPiece, functionality, sectionNode);
        for (String variable : constructor.variableCollective) {
            if (syntaxPiece.getVariableUsage(variable) != VariableUsage.CONFLICTING) continue;
            Skript.error((String)("Constructor syntax allows conflicting specification of the variable '" + variable + "'!"));
            return Optional.empty();
        }
        return Optional.of(constructor);
    }

    public void load() {
        ScriptLoader.setCurrentEvent((String)"WebSocketClientConstructor", (Class[])new Class[]{WebSocketClientConstructorEvent.class});
        this.triggerItem = ScopeUtil.loadSectionNodeOrDummy(this.sectionNode, null);
    }

    private SyntaxPiece.MarkSpecificInformation getMarkSpecificInformation(int mark) {
        return this.markSpecificInformationMap.computeIfAbsent(mark, __ -> {
            SyntaxPiece.MarkSpecificInformation result = new SyntaxPiece.MarkSpecificInformation();
            this.syntax.setInformation(result, mark, 0);
            return result;
        });
    }

    public WebSocket construct(Event event, int mark, Expression[] expressions) {
        URI uri;
        if (this.triggerItem == null) {
            throw new IllegalStateException("The triggerItem should have been loaded before WebSocketConstructor#construct() was called");
        }
        WebSocketClientConstructorEvent constructorEvent = new WebSocketClientConstructorEvent();
        VariablesMapManipulator vmm = new VariablesMapManipulator(this.functionality.getWebSocketVariableKeys(), null);
        VariablesMapManipulator.setParentVariables(constructorEvent, vmm);
        SyntaxPiece.MarkSpecificInformation markSpecificInformation = this.getMarkSpecificInformation(mark);
        markSpecificInformation.exprIndexes.forEach((variable, ix) -> {
            ExpressionConstraints expressionConstraints = this.variableCollective.getExpression((String)variable);
            Expression expression = expressions[ix];
            for (ExpressionConstraints.Type type : expressionConstraints.types) {
                if (!type.classInfo.getC().isAssignableFrom(expression.getReturnType()) || !expression.isSingle() && type.isSingle) continue;
                if (type.isSingle) {
                    constructorEvent.setLocalVariable((String)variable, expression.getSingle(event));
                    break;
                }
                Object[] array = expression.getArray(event);
                for (int i = 1; i <= array.length; ++i) {
                    constructorEvent.setLocalVariable(variable + "::" + i, array[i - 1]);
                }
            }
        });
        markSpecificInformation.markVarValues.forEach(constructorEvent::setLocalVariable);
        TriggerItem.walk((TriggerItem)this.triggerItem, (Event)constructorEvent);
        try {
            uri = new URI(constructorEvent.serverURI);
        }
        catch (URISyntaxException e) {
            Logging.reportException(this, e);
            return null;
        }
        catch (NullPointerException e) {
            Logging.debug((Object)this, e);
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        constructorEvent.request.iterateHttpFields().forEachRemaining(name -> headers.put((String)name, constructorEvent.request.getFieldValue((String)name)));
        WebSKTClient result = new WebSKTClient(this.functionality, uri, headers, vmm);
        result.connect();
        return result;
    }
}

