/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.classes;

import ch.njol.skript.Skript;
import java.net.InetSocketAddress;
import org.bukkit.Bukkit;
import us.tlatoani.webskt.WebSKT;
import us.tlatoani.webskt.classes.WebSKTServerFactory;
import us.tlatoani.webskt.core.base.Logging;
import us.tlatoani.webskt.events.WebSocketCloseEvent;
import us.tlatoani.webskt.events.WebSocketErrorEvent;
import us.tlatoani.webskt.events.WebSocketHandshakeEvent;
import us.tlatoani.webskt.events.WebSocketMessageEvent;
import us.tlatoani.webskt.events.WebSocketOpenEvent;
import us.tlatoani.webskt.events.WebSocketServerStartEvent;
import us.tlatoani.webskt.events.WebSocketServerStopEvent;
import us.tlatoani.webskt.java_websocket.WebSocket;
import us.tlatoani.webskt.java_websocket.drafts.Draft;
import us.tlatoani.webskt.java_websocket.exceptions.InvalidDataException;
import us.tlatoani.webskt.java_websocket.handshake.ClientHandshake;
import us.tlatoani.webskt.java_websocket.handshake.ServerHandshakeBuilder;
import us.tlatoani.webskt.java_websocket.server.WebSocketServer;
import us.tlatoani.webskt.template.WebSocketServerFunctionality;
import us.tlatoani.webskt.variables.VariablesMapManipulator;

public class WebSKTServer
extends WebSocketServer {
    public final WebSocketServerFunctionality functionality;
    public final VariablesMapManipulator vmm;

    public WebSKTServer(WebSocketServerFunctionality functionality, int port) {
        super(new InetSocketAddress(port));
        this.functionality = functionality;
        this.vmm = new VariablesMapManipulator(functionality.getServerVariableKeys(), null);
        this.setWebSocketFactory(new WebSKTServerFactory());
        Logging.debug((Object)this, functionality.toString());
    }

    @Override
    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        this.functionality.onOpen.run(new WebSocketOpenEvent.Server(this, conn, handshake));
    }

    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        Logging.debug((Object)this, "handshake received as server = " + this);
        ServerHandshakeBuilder response = super.onWebsocketHandshakeReceivedAsServer(conn, draft, request);
        WebSocketHandshakeEvent.Server event = new WebSocketHandshakeEvent.Server(this, conn, request, response);
        this.functionality.onHandshake.run(event);
        if (!event.allowed) {
            Logging.debug((Object)this, "connection disallowed, conn = " + conn);
            throw new InvalidDataException(1003);
        }
        Logging.debug((Object)this, "connection allowed, conn = " + conn);
        return response;
    }

    @Override
    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        this.functionality.onClose.run(new WebSocketCloseEvent.Server(this, conn, code, reason, remote));
    }

    @Override
    public void onMessage(WebSocket conn, String message) {
        this.functionality.onMessage.run(new WebSocketMessageEvent.Server(this, conn, message));
    }

    @Override
    public void onError(WebSocket conn, Exception ex) {
        this.functionality.onError.run(new WebSocketErrorEvent.Server(this, conn, ex));
        if (!this.functionality.onError.isPresent() && WebSKT.PRINT_WEBSOCKET_ERRORS.getCurrentValue().booleanValue()) {
            Logging.info("An websocket error has occured within WebSKT");
            Logging.info("If you are unsure of why this error is occurring, please create an issue on WebSKT's GitHub page: " + WebSKT.getGitHubLink());
            Logging.info("Bukkit/Spigot version: " + Bukkit.getVersion());
            Logging.info("Skript version: " + Skript.getVersion());
            Logging.info("WebSKT version: " + WebSKT.version());
            if (conn.getRemoteSocketAddress() == null) {
                Logging.info("Error in websocket server \"" + this.functionality.id + "\", local port = " + this.getAddress().getPort());
            } else {
                Logging.info("Error in websocket server \"" + this.functionality.id + "\", local port = " + this.getAddress().getPort() + ", remote host = " + conn.getRemoteSocketAddress().getHostName() + ", remote port = " + conn.getRemoteSocketAddress().getPort());
            }
            ex.printStackTrace();
        }
    }

    @Override
    public void onStart() {
        this.functionality.onStart.run(new WebSocketServerStartEvent(this));
    }

    @Override
    public void stop(int timeout) throws InterruptedException {
        super.stop(timeout);
        this.functionality.onStop.run(new WebSocketServerStopEvent(this));
    }

    public String toString() {
        return "websocket server \"" + this.functionality.id + "\" at port " + this.getAddress().getPort() + " with hashcode " + Integer.toHexString(this.hashCode());
    }
}

