/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.webskt.classes;

import ch.njol.skript.Skript;
import java.net.URI;
import java.util.Map;
import org.bukkit.Bukkit;
import us.tlatoani.webskt.WebSKT;
import us.tlatoani.webskt.core.base.Logging;
import us.tlatoani.webskt.events.WebSocketCloseEvent;
import us.tlatoani.webskt.events.WebSocketErrorEvent;
import us.tlatoani.webskt.events.WebSocketHandshakeEvent;
import us.tlatoani.webskt.events.WebSocketMessageEvent;
import us.tlatoani.webskt.events.WebSocketOpenEvent;
import us.tlatoani.webskt.java_websocket.WebSocket;
import us.tlatoani.webskt.java_websocket.client.WebSocketClient;
import us.tlatoani.webskt.java_websocket.handshake.ClientHandshake;
import us.tlatoani.webskt.java_websocket.handshake.ServerHandshake;
import us.tlatoani.webskt.template.WebSocketClientFunctionality;
import us.tlatoani.webskt.variables.VariablesMapManipulator;

public class WebSKTClient
extends WebSocketClient {
    public final WebSocketClientFunctionality functionality;
    public final VariablesMapManipulator vmm;

    public WebSKTClient(WebSocketClientFunctionality functionality, URI serverURI) {
        super(serverURI);
        this.functionality = functionality;
        this.vmm = new VariablesMapManipulator(functionality.getWebSocketVariableKeys(), null);
    }

    public WebSKTClient(WebSocketClientFunctionality functionality, URI serverURI, Map<String, String> headers) {
        super(serverURI, headers);
        this.functionality = functionality;
        this.vmm = new VariablesMapManipulator(functionality.getWebSocketVariableKeys(), null);
    }

    public WebSKTClient(WebSocketClientFunctionality functionality, URI serverURI, Map<String, String> headers, VariablesMapManipulator vmm) {
        super(serverURI, headers);
        this.functionality = functionality;
        this.vmm = vmm;
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) {
        this.functionality.onHandshake.run(new WebSocketHandshakeEvent.Client(this, request, response));
    }

    @Override
    public void onOpen(ServerHandshake handshakedata) {
        this.functionality.onOpen.run(new WebSocketOpenEvent.Client(this, handshakedata));
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        this.functionality.onClose.run(new WebSocketCloseEvent(this, code, reason, remote));
    }

    @Override
    public void onMessage(String message) {
        this.functionality.onMessage.run(new WebSocketMessageEvent(this, message));
    }

    @Override
    public void onError(Exception ex) {
        this.functionality.onError.run(new WebSocketErrorEvent(this, ex));
        if (!this.functionality.onError.isPresent() && WebSKT.PRINT_WEBSOCKET_ERRORS.getCurrentValue().booleanValue()) {
            Logging.info("An websocket error has occured within WebSKT");
            Logging.info("If you are unsure of why this error is occurring, please create an issue on WebSKT's GitHub link: " + WebSKT.getGitHubLink());
            Logging.info("Bukkit/Spigot version: " + Bukkit.getVersion());
            Logging.info("Skript version: " + Skript.getVersion());
            Logging.info("WebSKT version: " + WebSKT.version());
            if (this.getRemoteSocketAddress() == null) {
                Logging.info("Error in websocket client \"" + this.functionality.id + "\"");
            } else {
                Logging.info("Error in websocket client \"" + this.functionality.id + "\", remote host = " + this.getRemoteSocketAddress().getHostName() + ", remote port = " + this.getRemoteSocketAddress().getPort());
            }
            ex.printStackTrace();
        }
    }

    public String toString() {
        if (this.getRemoteSocketAddress() == null) {
            return "websocket client \"" + this.functionality.id + "\" with hashcode " + this.hashCode();
        }
        return "websocket client \"" + this.functionality.id + "\" connected to host \"" + this.getRemoteSocketAddress().getHostName() + "\" port " + this.getRemoteSocketAddress().getPort() + " with hashcode " + Integer.toHexString(this.hashCode());
    }
}

