/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;

public class ReflectionUtils {
    public static final String packageVersion = Bukkit.getServer().getClass().getPackage().getName().split(".v")[1];

    public static boolean hasClass(String clz) {
        try {
            Class.forName(clz);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Class<?> getClass(String clz) {
        try {
            return Class.forName(clz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clz, Class<?> ... parameters) {
        try {
            return clz.getConstructor(parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean hasMethod(Class<?> clz, String method, Class<?> ... parameters) {
        try {
            return ReflectionUtils.getMethod(clz, method, parameters) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Method getMethod(Class<?> clz, String method, Class<?> ... parameters) {
        try {
            return clz.getDeclaredMethod(method, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T invokeMethod(Class<?> clz, String method, Object instance, Object ... parameters) {
        try {
            Class[] parameterTypes = new Class[parameters.length];
            int x = 0;
            for (Object obj : parameters) {
                parameterTypes[x++] = obj.getClass();
            }
            Method m = clz.getDeclaredMethod(method, parameterTypes);
            m.setAccessible(true);
            return (T)m.invoke(instance, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            method.setAccessible(true);
            return (T)method.invoke(instance, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clz) {
        try {
            Constructor<T> c = clz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... objects) {
        try {
            return constructor.newInstance(objects);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> boolean setField(Class<T> from, Object obj, String field, Object newValue) {
        try {
            Field f = from.getDeclaredField(field);
            f.setAccessible(true);
            f.set(obj, newValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static <T> T getField(Class<?> from, Object obj, String field) {
        try {
            Field f = from.getDeclaredField(field);
            f.setAccessible(true);
            return (T)f.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

