/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.util;

import ch.njol.skript.lang.TriggerItem;
import com.pikachu.webaddon.util.DelayFork;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

public abstract class AsyncEffect
extends DelayFork {
    private static final ReentrantLock SCRIPT_EXECUTION = new ReentrantLock(true);
    private static final ExecutorService THREADS = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    @Nullable
    protected TriggerItem walk(Event e) {
        this.debug(e, true);
        DelayFork.addDelayedEvent(e);
        CompletableFuture<Void> run = CompletableFuture.runAsync(() -> this.execute(e), THREADS);
        run.whenComplete((r, err) -> {
            if (err != null) {
                err.printStackTrace();
            }
            SCRIPT_EXECUTION.lock();
            try {
                if (this.getNext() != null) {
                    AsyncEffect.walk((TriggerItem)this.getNext(), (Event)e);
                }
            }
            finally {
                SCRIPT_EXECUTION.unlock();
            }
        });
        return null;
    }
}

