/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.scopes;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.pikachu.webaddon.skript.expressions.ExprMultilineText;
import com.pikachu.webaddon.util.scope.EffectSection;
import java.lang.reflect.Field;
import java.util.List;
import org.bukkit.event.Event;

public class ScopeText
extends EffectSection {
    private static final Field NODE_LIST;
    private String text;

    private String nodeToString(SectionNode node, boolean appendKey) throws IllegalAccessException {
        StringBuilder builder = appendKey ? new StringBuilder(node.getKey()) : new StringBuilder();
        for (Node n : (List)NODE_LIST.get(node)) {
            builder.append("\n");
            builder.append(n.getKey());
            if (!(n instanceof SectionNode)) continue;
            builder.append(this.nodeToString((SectionNode)n, true));
        }
        return builder.length() == 0 ? null : builder.toString().substring(1);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (this.checkIfCondition(false)) {
            Skript.error((String)"You may not use 'if' or 'else if' with a multiline text scope");
            return false;
        }
        if (!this.hasSection()) {
            Skript.error((String)"A multiline text scope may not stand alone");
            return false;
        }
        if (NODE_LIST == null) {
            Skript.error((String)"Multiline text scopes are not compatible with this Skript version");
            return false;
        }
        try {
            this.text = this.nodeToString(this.getSectionNode(), false);
        }
        catch (IllegalAccessException e) {
            Skript.error((String)"Failed to extract text from multiline scope");
            return false;
        }
        return true;
    }

    @Override
    public void execute(Event e) {
        ExprMultilineText.lastText = this.text;
    }

    public String toString(Event e, boolean debug) {
        return "multiline string";
    }

    static {
        Skript.registerCondition(ScopeText.class, (String[])new String[]{"[multi[(-| )]line] (text|string)"});
        Field _NODE_LIST = null;
        try {
            _NODE_LIST = SectionNode.class.getDeclaredField("nodes");
            _NODE_LIST.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Skript.error((String)"Couldn't resolve Skript's 'node list' field. The multiline text scope will not work");
        }
        NODE_LIST = _NODE_LIST;
    }
}

