/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.pikachu.webaddon.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import org.bukkit.event.Event;

@Name(value="URL Encoded")
@Description(value={"URL encodes a string"})
@Examples(value={"broadcast url safe \"cool this is url safe!\""})
public class ExprURLSafe
extends SimpleExpression<String> {
    private Expression<String> strings;

    public String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected String[] get(Event e) {
        return (String[])Arrays.stream(this.strings.getArray(e)).map(this::encode).toArray(String[]::new);
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return this.strings.isSingle();
    }

    public String toString(Event e, boolean debug) {
        return "url safe " + this.strings.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.strings = exprs[0];
        return true;
    }

    static {
        if (!Util.runningReqn()) {
            Skript.registerExpression(ExprURLSafe.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(http|ur(i|l)) (safe|encoded|escaped) %strings%"});
        }
    }
}

