/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.event.Event;
import spark.Request;

@Name(value="Splat Parameters")
@Description(value={"The \"splat\" parameters (e.g. if you had scope 'get /user/*:' the splat parameterwould be the text represented by the *."})
@Examples(value={"set {_l::*} to splat parameters"})
public class ExprSplatParams
extends SimpleExpression<String> {
    private Expression<Request> requests;

    protected String[] get(Event e) {
        ArrayList splat = new ArrayList();
        for (Request request : (Request[])this.requests.getArray(e)) {
            Collections.addAll(splat, request.splat());
        }
        return splat.toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "splat parameters of " + this.requests.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.requests = exprs[0];
        return true;
    }

    static {
        PropertyExpression.register(ExprSplatParams.class, String.class, (String)"splat param[eter][s]", (String)"requests");
    }
}

