/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import spark.Session;

@Name(value="Creation Date")
@Description(value={"The date a session was created"})
@Examples(value={"if difference between now and creation date of event-request's session is less than 5 minutes:"})
public class ExprCreationDate
extends SimplePropertyExpression<Session, Date> {
    public Date convert(Session session) {
        return new Date(session.creationTime());
    }

    protected String getPropertyName() {
        return "creation date";
    }

    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    static {
        PropertyExpression.register(ExprCreationDate.class, Date.class, (String)"creation date", (String)"sessions");
    }
}

