/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import org.bukkit.event.Event;
import spark.Request;
import spark.Response;

@Name(value="Cookie")
@Description(value={"The value of a request/response's cookie"})
@Examples(value={"set cookie \"chocolateChip\" of event-response to \"true\""})
public class ExprCookie
extends SimpleExpression<String> {
    private Expression<String> cookie;
    private Expression<Object> web;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.web = exprs[matchedPattern ^ 1];
        this.cookie = exprs[matchedPattern];
        return true;
    }

    protected String[] get(Event e) {
        String cookie = (String)this.cookie.getSingle(e);
        return cookie == null ? new String[]{} : (String[])Arrays.stream(this.web.getArray(e)).filter(Request.class::isInstance).map(o -> ((Request)o).cookie(cookie)).toArray(String[]::new);
    }

    public boolean isSingle() {
        return this.web.isSingle();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class returnType = this.web.getReturnType();
        if (returnType != Response.class && returnType != Object.class) {
            Skript.error((String)"Only response cookies may be changed");
            return null;
        }
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String cookie = (String)this.cookie.getSingle(e);
        if (cookie != null) {
            Arrays.stream(this.web.getArray(e)).filter(Response.class::isInstance).map(o -> (Response)o).forEach(response -> {
                switch (mode) {
                    case SET: {
                        response.cookie(cookie, (String)delta[0]);
                        break;
                    }
                    case DELETE: {
                        response.raw().setHeader(cookie, null);
                    }
                }
            });
        }
    }

    public String toString(Event e, boolean debug) {
        return "cookie " + this.cookie.toString(e, debug) + " of " + this.web.toString(e, debug);
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        PropertyExpression.register(ExprCookie.class, String.class, (String)"cookie %string%", (String)"requests/responses");
    }
}

