/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.pikachu.webaddon.util.ConvertibleSimpleExpression;
import com.pikachu.webaddon.util.Util;
import java.util.stream.Stream;
import org.bukkit.event.Event;
import spark.Request;

@Name(value="Attribute")
@Description(value={"An attribute of a request"})
@Examples(value={"set attribute \"handler\" of event-request to \"CoolServer2\""})
public class ExprAttribute<T>
extends ConvertibleSimpleExpression<T> {
    private Expression<String> attribute;
    private Expression<Request> requests;
    private ExprAttribute<?> source;
    private Class<T> superType;

    public ExprAttribute() {
        this(null, Object.class);
    }

    private ExprAttribute(ExprAttribute<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.attribute = source.attribute;
            this.requests = source.requests;
        }
        this.superType = Utils.getSuperType((Class[])types);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.requests = exprs[matchedPattern ^ 1];
        this.attribute = exprs[matchedPattern];
        return true;
    }

    @Override
    protected T[] get(Event e) {
        String attribute = (String)this.attribute.getSingle(e);
        if (attribute == null) {
            return null;
        }
        try {
            return Util.convertStrictly(Stream.of(this.requests.getArray(e)).map(r -> r.attribute(attribute)).toArray(), this.superType);
        }
        catch (ClassCastException e1) {
            return null;
        }
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }

    @Override
    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String attribute = (String)this.attribute.getSingle(e);
        if (attribute == null) {
            return;
        }
        Stream.of(this.requests.getArray(e)).forEach(r -> {
            switch (mode) {
                case DELETE: {
                    r.attribute(attribute, null);
                    break;
                }
                case SET: {
                    r.attribute(attribute, delta[0]);
                }
            }
        });
    }

    public boolean isSingle() {
        return this.requests.isSingle();
    }

    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprAttribute<R>(this, to);
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    public String toString(Event e, boolean debug) {
        return "attribute " + this.attribute.toString(e, debug) + " of " + this.requests.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprAttribute.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"attribute %string% of %requests%", "%requests%'[s] attribute %string%"});
    }
}

