/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import ch.njol.util.Kleenean;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.bukkit.event.Event;
import spark.Response;

@Name(value="Send File")
@Description(value={"Sends a file (e.g. an image)"})
@Examples(value={"open a web server on port 8080:", "\tget /images/%{_image}%:", "\t\tsend back file \"website/images/%{_image}%\""})
public class EffSendBackFile
extends Effect {
    private Expression<String> file;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (ScriptLoader.getCurrentEvents() != null && Arrays.stream(ScriptLoader.getCurrentEvents()).anyMatch(event -> EventValues.getEventValueGetter((Class)event, Response.class, (int)0) != null)) {
            this.file = exprs[0];
            return true;
        }
        Skript.error((String)"You may only use 'send back' in events with a response");
        return false;
    }

    protected void execute(Event e) {
        Response response = (Response)EventValues.getEventValue((Event)e, Response.class, (int)0);
        String file = (String)this.file.getSingle(e);
        if (response != null && file != null) {
            try {
                byte[] fileData = Files.readAllBytes(Paths.get(file, new String[0]));
                HttpServletResponse raw = response.raw();
                raw.getOutputStream().write(fileData);
                raw.getOutputStream().flush();
                raw.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "send back file" + this.file.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSendBackFile.class, (String[])new String[]{"send back file %string%"});
    }
}

