/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import org.bukkit.event.Event;
import spark.Response;

@Name(value="Send Back Text")
@Description(value={"Send some text back to the browser"})
@Examples(value={"open a web server on port 8080:", "\tget /: # navigating to 'localhost:8080' will show you 'hello world'", "\t\tsend back \"hello world!\""})
public class EffSendBack
extends Effect {
    private Expression<String> response;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (ScriptLoader.getCurrentEvents() != null && Arrays.stream(ScriptLoader.getCurrentEvents()).anyMatch(event -> EventValues.getEventValueGetter((Class)event, Response.class, (int)0) != null)) {
            this.response = exprs[0];
            return true;
        }
        Skript.error((String)"You may only use 'send back' in events with a response");
        return false;
    }

    protected void execute(Event e) {
        Response response = (Response)EventValues.getEventValue((Event)e, Response.class, (int)0);
        String body = (String)this.response.getSingle(e);
        if (response != null && body != null) {
            response.body(body);
        }
    }

    public String toString(Event e, boolean debug) {
        return "send back " + this.response.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSendBack.class, (String[])new String[]{"send back %string%", "send %string% back"});
    }
}

