/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import spark.Response;

@Name(value="Redirect")
@Description(value={"Redirects a browser to another place"})
@Examples(value={"redirect event-response to \"https://www.google.com\""})
public class EffRedirect
extends Effect {
    private Expression<Response> responses;
    private Expression<String> url;
    private Expression<Number> status;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.responses = exprs[0];
        this.url = exprs[1];
        this.status = exprs[2];
        return true;
    }

    protected void execute(Event e) {
        String url = (String)this.url.getSingle(e);
        if (url != null) {
            for (Response response : (Response[])this.responses.getArray(e)) {
                if (this.status != null) {
                    Number status = (Number)this.status.getSingle(e);
                    if (status == null) continue;
                    response.redirect(url, status.intValue());
                    continue;
                }
                response.redirect(url);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "redirect " + this.responses.toString(e, debug) + " to " + this.url.toString(e, debug) + (this.status == null ? "" : " with the status code " + this.status.toString(e, debug));
    }

    static {
        Skript.registerEffect(EffRedirect.class, (String[])new String[]{"redirect [%responses%] to %string% [with [the] (response|status) code %-number%]"});
    }
}

