/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.pikachu.webaddon.util.AsyncEffect;
import com.pikachu.webaddon.util.LiteralUtils;
import org.bukkit.event.Event;

@Name(value="Compute Expression")
@Description(value={"Computes an expression on another thread (aka in a way that doesn't lag your server). This is useful for requests which have bodies that take a long time to compute (e.g. images)."})
@Examples(value={"compute body of event-request", "broadcast \"%computed expression%\""})
public class EffCompute
extends AsyncEffect {
    public static Object[] result;
    private Expression<Object> objects;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.objects = LiteralUtils.defendExpression(exprs[0]);
        return LiteralUtils.canInitSafely(this.objects);
    }

    protected void execute(Event e) {
        result = this.objects.getArray(e);
    }

    public String toString(Event e, boolean debug) {
        return "compute " + this.objects.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCompute.class, (String[])new String[]{"compute %objects%"});
    }
}

