/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.scopes.http.requests;

import ch.njol.skript.Skript;
import ch.njol.skript.variables.Variables;
import com.pikachu.webaddon.bukkit.events.HTTPRequestEvent;
import com.pikachu.webaddon.util.scope.EffectSection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.event.Event;
import spark.Request;
import spark.Response;
import spark.Service;

public abstract class RequestScope
extends EffectSection {
    private static Set<String> patterns = new HashSet<String>();
    private Service server;

    public static Set<String> getPatterns() {
        return Collections.unmodifiableSet(patterns);
    }

    public static void register(Class<? extends RequestScope> clazz, String ... patterns) {
        Skript.registerCondition(clazz, (String[])patterns);
        for (int i = 0; i < patterns.length; ++i) {
            RequestScope.patterns.add(patterns[i].replaceAll("%(number|integer)%", "(\\d+)").replaceAll("<(.+?)>", "($1)"));
        }
    }

    public String run(Request request, Response response) {
        HTTPRequestEvent event = new HTTPRequestEvent(request, response);
        this.setParamVars(request, event);
        this.runSection(event);
        return event.getResponse().body();
    }

    public Service getServer() {
        return this.server;
    }

    public void setParamVars(Request request, Event event) {
        request.params().forEach((param, value) -> Variables.setVariable((String)param.substring(1), (Object)value, (Event)event, (boolean)true));
    }

    public void setServer(Service server) {
        this.server = server;
    }
}

