/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.scopes.http;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import com.pikachu.webaddon.bukkit.events.HTTPRequestEvent;
import com.pikachu.webaddon.bukkit.events.StubBukkitEvent;
import com.pikachu.webaddon.skript.scopes.http.requests.RequestScope;
import com.pikachu.webaddon.util.Util;
import com.pikachu.webaddon.util.scope.EventScope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;
import spark.Request;
import spark.Response;
import spark.Service;

public class ScopeHTTPServer
extends EventScope {
    private static boolean parsing;
    private static Set<Integer> usedPorts;
    private String stringRep;
    private int port;
    private List<SectionNode> rawNodes = new ArrayList<SectionNode>();
    private Service server;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        SectionNode sectionNode = (SectionNode)SkriptLogger.getNode();
        this.stringRep = sectionNode.getKey();
        String stringPort = ((MatchResult)parseResult.regexes.get(0)).group();
        if (stringPort.matches("\\d{1,5}")) {
            this.port = Integer.parseInt(stringPort);
            if (usedPorts.contains(this.port)) {
                Skript.error((String)("There is already a web server running on port " + this.port));
                return false;
            }
        } else {
            Skript.error((String)("'" + stringPort + "' is not a valid port"));
            return false;
        }
        if (this.stringRep.startsWith("on")) {
            Skript.error((String)"You may not use 'on' with a web server!");
            return false;
        }
        for (Node node : sectionNode) {
            Util.setKey(node, ScriptLoader.replaceOptions((String)node.getKey()));
            if (!(node instanceof SectionNode)) {
                Skript.error((String)"A web server may only contain request scopes");
                return false;
            }
            if (RequestScope.getPatterns().stream().noneMatch(p -> node.getKey().matches((String)p))) {
                Skript.error((String)("'" + node.getKey() + "' is not a request scope (e.g. 'get /index:')"));
                return false;
            }
            this.rawNodes.add((SectionNode)node);
        }
        if (this.rawNodes.isEmpty()) {
            Skript.error((String)"A web server without any routes is useless");
            return false;
        }
        Util.clearSectionNode(sectionNode);
        return true;
    }

    @Override
    public void load() {
        usedPorts.add(this.port);
        this.server = Service.ignite().port(this.port);
        for (SectionNode node : this.rawNodes) {
            RequestScope scope = (RequestScope)Condition.parse((String)node.getKey(), (String)("Can't understand this scope: '" + node.getKey() + "'"));
            if (scope == null) continue;
            TriggerSection trigger = Util.loadSectionNode(node, node.getKey(), true, "http event", HTTPRequestEvent.class);
            scope.setTrigger(trigger);
            scope.setServer(this.server);
            scope.check(null);
        }
        this.rawNodes.clear();
    }

    public void unregister(Trigger t) {
        this.server.options("workaroundForSparkNpe" + UUID.randomUUID().toString(), (req, resp) -> "you shouldn't be seeing this");
        this.server.stop();
        usedPorts.remove(this.port);
    }

    public void unregisterAll() {
        this.unregister(null);
    }

    public String toString(Event e, boolean debug) {
        return this.stringRep;
    }

    static {
        usedPorts = new HashSet<Integer>();
        Skript.registerEvent((String)"web server", ScopeHTTPServer.class, StubBukkitEvent.class, (String[])new String[]{"[open a] (web|http) server on port <.+>"});
        EventValues.registerEventValue(HTTPRequestEvent.class, Request.class, (Getter)new Getter<Request, HTTPRequestEvent>(){

            public Request get(HTTPRequestEvent arg) {
                return arg.getRequest();
            }
        }, (int)0);
        EventValues.registerEventValue(HTTPRequestEvent.class, Response.class, (Getter)new Getter<Response, HTTPRequestEvent>(){

            public Response get(HTTPRequestEvent arg) {
                return arg.getResponse();
            }
        }, (int)0);
    }
}

