/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.webaddon.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import org.bukkit.event.Event;
import spark.Request;
import spark.Response;

public class ExprHeader
extends SimpleExpression<String> {
    private Expression<String> header;
    private Expression<Object> web;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.web = matchedPattern == 1 ? exprs[0] : exprs[1];
        this.header = matchedPattern == 1 ? exprs[1] : exprs[0];
        return true;
    }

    protected String[] get(Event e) {
        String header = (String)this.header.getSingle(e);
        return header == null ? new String[]{} : (String[])Arrays.stream(this.web.getArray(e)).map(o -> o instanceof Request ? ((Request)o).headers(header) : ((Response)o).raw().getHeader(header)).toArray(String[]::new);
    }

    public boolean isSingle() {
        return this.web.isSingle();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class returnType = this.web.getReturnType();
        if (returnType != Response.class && returnType != Object.class) {
            Skript.error((String)"Only response headers may be changed");
            return null;
        }
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String header = (String)this.header.getSingle(e);
        if (header != null) {
            Arrays.stream(this.web.getArray(e)).filter(Response.class::isInstance).map(o -> (Response)o).forEach(response -> {
                switch (mode) {
                    case SET: {
                        response.raw().setHeader(header, (String)delta[0]);
                        break;
                    }
                    case DELETE: {
                        response.raw().setHeader(header, null);
                    }
                }
            });
        }
    }

    public String toString(Event e, boolean debug) {
        return "header " + this.header.toString(e, debug) + " of " + this.web.toString(e, debug);
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        PropertyExpression.register(ExprHeader.class, String.class, (String)"header %string%", (String)"requests/responses");
    }
}

