/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.registration;

import ch.njol.skript.registrations.EventValues;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.registration.Registration;
import org.bukkit.event.Event;

public class Documentation {
    public static void setupSyntaxFile() {
        File file = new File(Vixio.getInstance().getDataFolder(), "Syntaxes.txt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileWriter fw = new FileWriter(file, true);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(Documentation.tab("Conditions:", 0));
            Documentation.writeRegistration(bw, Vixio.getInstance().conditions);
            bw.write(Documentation.tab("Effects:", 0));
            Documentation.writeRegistration(bw, Vixio.getInstance().effects);
            bw.write(Documentation.tab("Expressions:", 0));
            Documentation.writeRegistration(bw, Vixio.getInstance().expressions);
            bw.write(Documentation.tab("Events:", 0));
            Documentation.writeRegistration(bw, Vixio.getInstance().events);
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean writeRegistration(BufferedWriter bw, List<Registration> registrationList) {
        try {
            for (Registration registration : registrationList) {
                bw.write(Documentation.tab("name: " + registration.getName(), 1));
                bw.write(Documentation.tab("description: " + registration.getDesc(), 2));
                bw.write(Documentation.tab("patterns:", 2));
                if (registration.getUserFacing() == null) {
                    for (String pattern : registration.getSyntaxes()) {
                        bw.write(Documentation.tab("- " + pattern, 3));
                    }
                    continue;
                }
                bw.write(Documentation.tab("- " + registration.getUserFacing(), 3));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void generateJson() {
        File file = new File(Vixio.getInstance().getDataFolder(), "syntaxes.json");
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileWriter fw = new FileWriter(file, true);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("{\n");
            bw.write("\t\"events\": [\n");
            int events = Vixio.getInstance().events.size();
            int i = 0;
            for (Registration registration : Vixio.getInstance().events) {
                String[] splitExample;
                ++i;
                if (registration.getEvent() == null) continue;
                bw.write(Documentation.tab("{", 2));
                bw.write(Documentation.tab("\"description\": \"" + Documentation.escapeString(registration.getDesc()) + "\",", 3));
                bw.write(Documentation.tab("\"name\": \"" + registration.getName() + "\",", 3));
                bw.write(Documentation.tab("\"patterns\": [", 3));
                if (registration.getSyntaxes().length > 1) {
                    int patterns = 0;
                    for (String pattern : registration.getSyntaxes()) {
                        if (++patterns < registration.getSyntaxes().length) {
                            bw.write(Documentation.tab("\"" + pattern + "\",", 4));
                            continue;
                        }
                        bw.write(Documentation.tab("\"" + pattern + "\"", 4));
                    }
                } else {
                    bw.write(Documentation.tab("\"" + registration.getSyntax() + "\"", 4));
                }
                bw.write(Documentation.tab("],", 3));
                if (registration.getEvent() != null) {
                    List<String> eventValues = Documentation.getEventValues(registration.getEvent());
                    bw.write(Documentation.tab("\"eventvalues\": [", 3));
                    int eventValue = 0;
                    for (String s : eventValues) {
                        if (++eventValue < eventValues.size()) {
                            bw.write(Documentation.tab("\"" + s + "\",", 4));
                            continue;
                        }
                        bw.write(Documentation.tab("\"" + s + "\"", 4));
                    }
                }
                bw.write(Documentation.tab("],", 3));
                bw.write(Documentation.tab("\"examples\": [", 3));
                int examples = 0;
                for (String example : splitExample = registration.getExample().split(",")) {
                    if (++examples < splitExample.length) {
                        bw.write(Documentation.tab("\"" + Documentation.escapeString(example) + "\",", 4));
                        continue;
                    }
                    bw.write(Documentation.tab("\"" + Documentation.escapeString(example) + "\"", 4));
                }
                bw.write(Documentation.tab("]", 3));
                if (i < events) {
                    bw.write(Documentation.tab("},", 2));
                    continue;
                }
                bw.write(Documentation.tab("}", 2));
                bw.write(Documentation.tab("],", 1));
            }
            bw.write(Documentation.tab("\"conditions\": [", 1));
            int conditions = Vixio.getInstance().conditions.size();
            int conditionCount = 0;
            for (Registration registration : Vixio.getInstance().conditions) {
                String[] splitExample;
                ++conditionCount;
                bw.write(Documentation.tab("{", 2));
                bw.write(Documentation.tab("\"description\": \"" + Documentation.escapeString(registration.getDesc()) + "\",", 2));
                bw.write(Documentation.tab("\"name\": \"" + registration.getName() + "\",", 2));
                bw.write(Documentation.tab("\"patterns\": [", 3));
                if (registration.getUserFacing() != null) {
                    bw.write(Documentation.tab("\"" + registration.getUserFacing() + "\"", 4));
                } else if (registration.getSyntaxes().length > 1) {
                    int patterns = 0;
                    for (String pattern : registration.getSyntaxes()) {
                        if (++patterns < registration.getSyntaxes().length) {
                            bw.write(Documentation.tab("\"" + pattern + "\",", 4));
                            continue;
                        }
                        bw.write(Documentation.tab("\"" + pattern + "\"", 4));
                    }
                } else {
                    bw.write(Documentation.tab("\"" + registration.getSyntax() + "\"", 4));
                }
                bw.write(Documentation.tab("],", 3));
                bw.write(Documentation.tab("\"examples\": [", 3));
                int examples = 0;
                for (String example : splitExample = registration.getExample().split(",")) {
                    if (++examples < splitExample.length) {
                        bw.write(Documentation.tab("\"" + Documentation.escapeString(example) + "\",", 4));
                        continue;
                    }
                    bw.write(Documentation.tab("\"" + Documentation.escapeString(example) + "\"", 4));
                }
                bw.write(Documentation.tab("]", 3));
                if (conditionCount < conditions) {
                    bw.write(Documentation.tab("},", 2));
                    continue;
                }
                bw.write(Documentation.tab("}", 2));
                bw.write(Documentation.tab("],", 1));
            }
            bw.write(Documentation.tab("\"effects\": [", 1));
            int effects = Vixio.getInstance().effects.size();
            int effectsCount = 0;
            for (Registration registration : Vixio.getInstance().effects) {
                String[] splitExample;
                ++effectsCount;
                bw.write(Documentation.tab("{", 2));
                bw.write(Documentation.tab("\"description\": \"" + Documentation.escapeString(registration.getDesc()) + "\",", 2));
                bw.write(Documentation.tab("\"name\": \"" + registration.getName() + "\",", 2));
                bw.write(Documentation.tab("\"patterns\": [", 3));
                if (registration.getUserFacing() != null) {
                    bw.write(Documentation.tab("\"" + registration.getUserFacing() + "\"", 4));
                } else if (registration.getSyntaxes().length > 1) {
                    int patterns = 0;
                    for (String pattern : registration.getSyntaxes()) {
                        if (++patterns < registration.getSyntaxes().length) {
                            bw.write(Documentation.tab("\"" + pattern + "\",", 4));
                            continue;
                        }
                        bw.write(Documentation.tab("\"" + pattern + "\"", 4));
                    }
                } else {
                    bw.write(Documentation.tab("\"" + registration.getSyntax() + "\"", 4));
                }
                bw.write(Documentation.tab("],", 3));
                bw.write(Documentation.tab("\"examples\": [", 3));
                int examples = 0;
                for (String example : splitExample = registration.getExample().split(",")) {
                    if (++examples < splitExample.length) {
                        bw.write(Documentation.tab("\"" + Documentation.escapeString(example) + "\",", 4));
                        continue;
                    }
                    bw.write(Documentation.tab("\"" + Documentation.escapeString(example) + "\"", 4));
                }
                bw.write(Documentation.tab("]", 3));
                if (effectsCount < effects) {
                    bw.write(Documentation.tab("},", 2));
                    continue;
                }
                bw.write(Documentation.tab("}", 2));
                bw.write(Documentation.tab("],", 1));
            }
            bw.write(Documentation.tab("\"expressions\": [", 1));
            int expressions = Vixio.getInstance().expressions.size();
            int expressionsCount = 0;
            for (Registration registration : Vixio.getInstance().expressions) {
                String[] splitExample;
                ++expressionsCount;
                bw.write(Documentation.tab("{", 2));
                bw.write(Documentation.tab("\"description\": \"" + Documentation.escapeString(registration.getDesc()) + "\",", 2));
                bw.write(Documentation.tab("\"name\": \"" + registration.getName() + "\",", 2));
                bw.write(Documentation.tab("\"patterns\": [", 3));
                if (registration.getUserFacing() != null) {
                    bw.write(Documentation.tab("\"" + registration.getUserFacing() + "\"", 4));
                } else if (registration.getSyntaxes().length > 1) {
                    int patterns = 0;
                    for (String pattern : registration.getSyntaxes()) {
                        if (++patterns < registration.getSyntaxes().length) {
                            bw.write(Documentation.tab("\"" + pattern + "\",", 4));
                            continue;
                        }
                        bw.write(Documentation.tab("\"" + pattern + "\"", 4));
                    }
                } else {
                    bw.write(Documentation.tab("\"" + registration.getSyntax() + "\"", 4));
                }
                bw.write(Documentation.tab("],", 3));
                bw.write(Documentation.tab("\"examples\": [", 3));
                int examples = 0;
                for (String example : splitExample = registration.getExample().split(",")) {
                    if (++examples < splitExample.length) {
                        bw.write(Documentation.tab("\"" + Documentation.escapeString(example) + "\",", 4));
                        continue;
                    }
                    bw.write(Documentation.tab("\"" + Documentation.escapeString(example) + "\"", 4));
                }
                bw.write(Documentation.tab("]", 3));
                if (expressionsCount < expressions) {
                    bw.write(Documentation.tab("},", 2));
                    continue;
                }
                bw.write(Documentation.tab("}", 2));
                bw.write(Documentation.tab("]", 1));
                bw.write("}");
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<String> getEventValues(Class<? extends Event> ... classes) {
        Method m = Documentation.getMethod(EventValues.class, "getEventValuesList", Integer.TYPE);
        List values = (List)Documentation.invokeMethod(m, null, 0);
        ArrayList<String> eventValues = new ArrayList<String>();
        if (values != null) {
            for (Class<? extends Event> c : classes) {
                for (Object eventValue : values) {
                    Class event = (Class)Documentation.getField(eventValue.getClass(), eventValue, "event");
                    if (event == null || !c.isAssignableFrom(event) && !event.isAssignableFrom(c)) continue;
                    Class ret = (Class)Documentation.getField(eventValue.getClass(), eventValue, "c");
                    eventValues.add("event-" + ret.getSimpleName().toLowerCase().replaceAll("updatingmessage", "message"));
                }
            }
        }
        return eventValues;
    }

    public static Method getMethod(Class<?> clz, String method, Class<?> ... parameters) {
        try {
            return clz.getDeclaredMethod(method, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T invokeMethod(Class<?> clz, String method, Object instance, Object ... parameters) {
        try {
            Class[] parameterTypes = new Class[parameters.length];
            int x = 0;
            for (Object obj : parameters) {
                parameterTypes[x++] = obj.getClass();
            }
            Method m = clz.getDeclaredMethod(method, parameterTypes);
            m.setAccessible(true);
            return (T)m.invoke(instance, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            method.setAccessible(true);
            return (T)method.invoke(instance, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T getField(Class<?> from, Object obj, String field) {
        try {
            Field f = from.getDeclaredField(field);
            f.setAccessible(true);
            return (T)f.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String tab(String s, int tabs) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tabs; ++i) {
            builder.append("\t");
        }
        builder.append(s + "\n");
        return builder.toString();
    }

    public static String escapeString(String s) {
        return s.replaceAll("\t", "\\\\t").replaceAll("\"", "\\\"");
    }
}

