/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.message;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.List;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.skript.EasyMultiple;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import org.bukkit.event.Event;

public class ExprMentionedChannels
extends SimpleExpression<TextChannel>
implements EasyMultiple<UpdatingMessage, TextChannel> {
    private Expression<UpdatingMessage> messages;

    protected TextChannel[] get(Event e) {
        return (TextChannel[])this.convert(this.getReturnType(), this.messages.getAll(e), msg -> {
            Message message = UpdatingMessage.convert(msg);
            List<TextChannel> textChannels = message.getMentionedChannels();
            return textChannels.toArray(new TextChannel[textChannels.size()]);
        });
    }

    public String toString(Event e, boolean debug) {
        return "mentioned channels of " + this.messages.toString(e, debug);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends TextChannel> getReturnType() {
        return TextChannel.class;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.messages = exprs[0];
        return true;
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprMentionedChannels.class, TextChannel.class, "mentioned channel", "messages").setName("Mentioned Channels").setDesc("Get the mentioned Channels in a Message").setExample("set {_var::*} to event-message's mentioned channels");
    }
}

