/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.guild;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.List;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Role;
import org.bukkit.event.Event;

public class ExprRoleNamed
extends SimpleExpression<Role> {
    private Expression<Guild> guild;
    private Expression<String> name;
    private boolean roles;

    protected Role[] get(Event e) {
        Role[] roleArray;
        Guild guild = (Guild)this.guild.getSingle(e);
        String name = (String)this.name.getSingle(e);
        if (guild == null || name == null || name.isEmpty()) {
            return null;
        }
        List<Role> roles = guild.getRolesByName(name, false);
        if (roles.size() > 1) {
            if (this.roles) {
                return new Role[]{roles.get(0)};
            }
            return roles.toArray(new Role[roles.size()]);
        }
        if (roles.isEmpty()) {
            roleArray = null;
        } else {
            Role[] roleArray2 = new Role[1];
            roleArray = roleArray2;
            roleArray2[0] = roles.get(0);
        }
        return roleArray;
    }

    public boolean isSingle() {
        return this.roles;
    }

    public Class<? extends Role> getReturnType() {
        return Role.class;
    }

    public String toString(Event e, boolean debug) {
        return "role named " + this.name.toString(e, debug) + " in guild ";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.guild = exprs[1];
        this.roles = parseResult.regexes.size() == 0;
        return true;
    }

    static {
        Vixio.getInstance().registerExpression(ExprRoleNamed.class, Role.class, ExpressionType.SIMPLE, "[the] role[<s>] (with [the] name|named) %string% [in %guild%]").setName("Role Named").setDesc("Get a role via it's name in a guild.").setExample("discord command $role <text>:", "\ttrigger:", "\t\tset {_role} to role named arg-1", "\t\tif {_role} is not set:", "\t\t\treply with \"Could not find a role by that name!\"", "\t\t\tstop", "\t\treply with \"I found the role! ID: %id of {_role}%\"");
    }
}

