/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.guild;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.Objects;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.changers.ChangeableSimpleExpression;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

public class ExprAfkChannel
extends ChangeableSimpleExpression<VoiceChannel> {
    private Expression<Guild> guilds;

    protected VoiceChannel[] get(Event e) {
        Guild[] guilds = (Guild[])this.guilds.getAll(e);
        if (guilds == null) {
            return null;
        }
        return (VoiceChannel[])Arrays.stream(guilds).filter(Objects::nonNull).map(Guild::getAfkChannel).toArray(VoiceChannel[]::new);
    }

    public boolean isSingle() {
        return this.guilds.isSingle();
    }

    public Class<? extends VoiceChannel> getReturnType() {
        return VoiceChannel.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode, boolean vixioChanger) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{VoiceChannel.class};
        }
        return null;
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        Guild[] guilds = (Guild[])this.guilds.getAll(e);
        if (guilds == null) {
            return;
        }
        VoiceChannel channel = (VoiceChannel)delta[0];
        for (Guild guild : guilds) {
            Guild boundGuild = Util.bindGuild(bot, guild);
            try {
                if (boundGuild == null) continue;
                boundGuild.getManager().setAfkChannel(channel).queue();
            }
            catch (PermissionException x) {
                Vixio.getErrorHandler().needsPerm(bot, "set afk channel", x.getPermission().getName());
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "afk channel of " + this.guilds.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.guilds = exprs[0];
        return true;
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprAfkChannel.class, VoiceChannel.class, "afk channel", "guilds").setName("Afk channel of Guild").setDesc("Get the AFK voice channel of a guild. You can set this to another channel.").setExample("discord command $afk:", "\ttrigger:", "\t\treply with \"%afk channel of event-guild%\"");
    }
}

