/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.channel;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.VoiceChannel;
import org.bukkit.event.Event;

public class ExprChannelNamed
extends SimpleExpression<GuildChannel> {
    private boolean singular;
    private Expression<Guild> guild;
    private Expression<String> name;
    private int mark;

    protected GuildChannel[] get(Event e) {
        Guild guild;
        String name = (String)this.name.getSingle(e);
        Guild guild2 = guild = this.guild == null ? null : (Guild)this.guild.getSingle(e);
        if (name == null) {
            return null;
        }
        if (guild != null) {
            if (this.mark == 0) {
                List<VoiceChannel> voiceChannels = guild.getVoiceChannelsByName(name, false);
                List<TextChannel> textChannels = guild.getTextChannelsByName(name, false);
                if (voiceChannels.isEmpty() && textChannels.isEmpty()) {
                    return null;
                }
                if (this.singular) {
                    GuildChannel channel = textChannels.isEmpty() ? (GuildChannel)voiceChannels.get(0) : (GuildChannel)textChannels.get(0);
                    return new GuildChannel[]{channel};
                }
                ArrayList<GuildChannel> channels = new ArrayList<GuildChannel>();
                int size = 0;
                if (!textChannels.isEmpty()) {
                    channels.addAll(textChannels);
                    size += textChannels.size();
                }
                if (!voiceChannels.isEmpty()) {
                    channels.addAll(voiceChannels);
                    size += voiceChannels.size();
                }
                return channels.toArray(new GuildChannel[size]);
            }
            if (this.mark == 1) {
                GuildChannel[] guildChannelArray;
                List<VoiceChannel> voiceChannels = guild.getVoiceChannelsByName(name, false);
                if (voiceChannels.isEmpty()) {
                    return null;
                }
                if (this.singular) {
                    VoiceChannel[] voiceChannelArray = new VoiceChannel[1];
                    guildChannelArray = voiceChannelArray;
                    voiceChannelArray[0] = voiceChannels.get(0);
                } else {
                    guildChannelArray = voiceChannels.toArray(new VoiceChannel[voiceChannels.size()]);
                }
                return guildChannelArray;
            }
            if (this.mark == 2) {
                GuildChannel[] guildChannelArray;
                List<TextChannel> textChannels = guild.getTextChannelsByName(name, false);
                if (textChannels.isEmpty()) {
                    return null;
                }
                if (this.singular) {
                    TextChannel[] textChannelArray = new TextChannel[1];
                    guildChannelArray = textChannelArray;
                    textChannelArray[0] = textChannels.get(0);
                } else {
                    guildChannelArray = textChannels.toArray(new TextChannel[textChannels.size()]);
                }
                return guildChannelArray;
            }
        }
        Set<JDA> jdaInstances = Vixio.getInstance().botHashMap.keySet();
        for (JDA jda : jdaInstances) {
            GuildChannel[] guildChannelArray;
            List<TextChannel> textChannels;
            List<VoiceChannel> voiceChannels;
            if (this.mark == 0) {
                voiceChannels = jda.getVoiceChannelsByName(name, false);
                textChannels = jda.getTextChannelsByName(name, false);
                if (voiceChannels.isEmpty() && textChannels.isEmpty()) continue;
                if (this.singular) {
                    GuildChannel[] guildChannelArray2;
                    if (voiceChannels.isEmpty()) {
                        TextChannel[] textChannelArray = new TextChannel[1];
                        guildChannelArray2 = textChannelArray;
                        textChannelArray[0] = textChannels.get(0);
                    } else {
                        VoiceChannel[] voiceChannelArray = new VoiceChannel[1];
                        guildChannelArray2 = voiceChannelArray;
                        voiceChannelArray[0] = voiceChannels.get(0);
                    }
                    return guildChannelArray2;
                }
                ArrayList<GuildChannel> channels = new ArrayList<GuildChannel>();
                int size = 0;
                if (!textChannels.isEmpty()) {
                    channels.addAll(textChannels);
                    size += textChannels.size();
                }
                if (!voiceChannels.isEmpty()) {
                    channels.addAll(voiceChannels);
                    size += voiceChannels.size();
                }
                return channels.toArray(new GuildChannel[size]);
            }
            if (this.mark == 1) {
                GuildChannel[] guildChannelArray3;
                voiceChannels = jda.getVoiceChannelsByName(name, false);
                if (voiceChannels.isEmpty()) continue;
                if (this.singular) {
                    VoiceChannel[] voiceChannelArray = new VoiceChannel[1];
                    guildChannelArray3 = voiceChannelArray;
                    voiceChannelArray[0] = voiceChannels.get(0);
                } else {
                    guildChannelArray3 = voiceChannels.toArray(new VoiceChannel[voiceChannels.size()]);
                }
                return guildChannelArray3;
            }
            if (this.mark != 2 || (textChannels = jda.getTextChannelsByName(name, false)).isEmpty()) continue;
            if (this.singular) {
                TextChannel[] textChannelArray = new TextChannel[1];
                guildChannelArray = textChannelArray;
                textChannelArray[0] = textChannels.get(0);
            } else {
                guildChannelArray = textChannels.toArray(new TextChannel[textChannels.size()]);
            }
            return guildChannelArray;
        }
        return null;
    }

    public boolean isSingle() {
        return this.singular;
    }

    public Class<? extends GuildChannel> getReturnType() {
        return GuildChannel.class;
    }

    public String toString(Event e, boolean debug) {
        return "channel named " + this.name.toString(e, debug) + (this.guild == null ? "" : " in " + this.guild.toString(e, debug));
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.singular = parseResult.regexes.size() == 0;
        this.mark = parseResult.mark;
        this.name = exprs[0];
        this.guild = exprs[1];
        return true;
    }

    static {
        Vixio.getInstance().registerExpression(ExprChannelNamed.class, GuildChannel.class, ExpressionType.SIMPLE, "[(1\u00a6voice|2\u00a6text)][(-| )]channel[<s>] (named|with name) %string% [in %-guild%]").setName("Channel Named").setDesc("Get a channel via it's name, you can include the type of channel and/or the guild to speed the retrieval process up. The searching is case sensitive.").setUserFacing("[(voice|text)][(-| )]channel[s] named %string% [in %-guild%]").setExample("discord command move <text>:", "\ttrigger:", "\t\tset {_} to voice channel named arg-1", "\t\tif voice channel of event-member is not set:", "\t\t\treply with \"Not in vc to move to\"", "\t\t\tstop", "\t\tmove event-member to {_}", "\t\treply with \"Done! %event-member% was moved to %{_}%\"");
    }
}

