/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.events;

import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.events.base.BaseEvent;
import me.iblitzkriegi.vixio.events.base.SimpleVixioEvent;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import me.iblitzkriegi.vixio.util.wrapper.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.react.MessageReactionRemoveEvent;
import net.dv8tion.jda.api.exceptions.RateLimitedException;

public class EvtReactionRemove
extends BaseEvent<MessageReactionRemoveEvent> {
    @Override
    public BaseEvent.Value[] getValues() {
        return new BaseEvent.Value[]{new BaseEvent.Value(Message.class, e -> {
            try {
                UpdatingMessage updatingMessage = UpdatingMessage.from(e.getMessageId());
                if (updatingMessage == null) {
                    return e.getChannel().retrieveMessageById(e.getMessageId()).complete(true);
                }
                return updatingMessage.getMessage();
            }
            catch (RateLimitedException e1) {
                Vixio.getErrorHandler().warn("Vixio tried to get the message event value for the reaction remove event but was rate limited");
                return null;
            }
        })};
    }

    static {
        BaseEvent.register("reaction remove[d]", EvtReactionRemove.class, ReactionRemoveEvent.class, "reaction remove[d]").setName("Reaction Remove").setDesc("Fired when a reaction is removed from a message").setExample("on reaction remove:");
        EventValues.registerEventValue(ReactionRemoveEvent.class, Bot.class, (Getter)new Getter<Bot, ReactionRemoveEvent>(){

            public Bot get(ReactionRemoveEvent event) {
                return Util.botFrom(((MessageReactionRemoveEvent)event.getJDAEvent()).getJDA());
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionRemoveEvent.class, User.class, (Getter)new Getter<User, ReactionRemoveEvent>(){

            public User get(ReactionRemoveEvent event) {
                return ((MessageReactionRemoveEvent)event.getJDAEvent()).getUser();
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionRemoveEvent.class, Member.class, (Getter)new Getter<Member, ReactionRemoveEvent>(){

            public Member get(ReactionRemoveEvent event) {
                return ((MessageReactionRemoveEvent)event.getJDAEvent()).getMember();
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionRemoveEvent.class, Guild.class, (Getter)new Getter<Guild, ReactionRemoveEvent>(){

            public Guild get(ReactionRemoveEvent event) {
                return ((MessageReactionRemoveEvent)event.getJDAEvent()).getGuild();
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionRemoveEvent.class, UpdatingMessage.class, (Getter)new Getter<UpdatingMessage, ReactionRemoveEvent>(){

            public UpdatingMessage get(ReactionRemoveEvent e) {
                return UpdatingMessage.from(e.getValue(Message.class));
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionRemoveEvent.class, MessageChannel.class, (Getter)new Getter<MessageChannel, ReactionRemoveEvent>(){

            public MessageChannel get(ReactionRemoveEvent event) {
                return ((MessageReactionRemoveEvent)event.getJDAEvent()).getChannel();
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionRemoveEvent.class, GuildChannel.class, (Getter)new Getter<GuildChannel, ReactionRemoveEvent>(){

            public GuildChannel get(ReactionRemoveEvent event) {
                return ((MessageReactionRemoveEvent)event.getJDAEvent()).getTextChannel();
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionRemoveEvent.class, Emote.class, (Getter)new Getter<Emote, ReactionRemoveEvent>(){

            public Emote get(ReactionRemoveEvent event) {
                MessageReaction.ReactionEmote reactionEmote = ((MessageReactionRemoveEvent)event.getJDAEvent()).getReactionEmote();
                if (!reactionEmote.isEmote()) {
                    return Util.unicodeFrom(reactionEmote.getName());
                }
                return new Emote(reactionEmote.getEmote());
            }
        }, (int)0);
    }

    public class ReactionRemoveEvent
    extends SimpleVixioEvent<MessageReactionRemoveEvent> {
    }
}

