/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.guild.punish;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

public class EffBanUser
extends Effect {
    private Expression<Object> users;
    private Expression<Guild> guild;
    private Expression<Object> bot;
    private Expression<Number> days;
    private Expression<String> reason;

    protected void execute(Event e) {
        Object[] users = this.users.getAll(e);
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        Guild guild = Util.bindGuild(bot, (Guild)this.guild.getSingle(e));
        if (bot == null || users == null || guild == null) {
            return;
        }
        Integer days = this.days == null ? (Number)0 : (Number)((Number)this.days.getSingle(e));
        String reason = this.reason == null ? null : (String)this.reason.getSingle(e);
        for (Object object : users) {
            String user = object instanceof User ? ((User)object).getId() : (String)object;
            try {
                guild.ban(user, (int)days, reason).queue();
            }
            catch (PermissionException x) {
                Vixio.getErrorHandler().needsPerm(bot, "ban user", x.getPermission().getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "ban " + this.users.toString(e, debug) + " from " + this.guild.toString(e, debug) + " " + (this.reason == null ? "" : "due to " + this.reason.toString(e, debug)) + (this.days == null ? "" : "and delete " + this.days.toString(e, debug) + " worth of messages ") + "as " + this.bot.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.users = exprs[0];
        this.guild = exprs[1];
        this.reason = exprs[2];
        this.days = exprs[3];
        this.bot = exprs[4];
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffBanUser.class, "ban %users/strings% from %guild% [(due to|with reason|because of) %-string%] [and delete %-number% days [worth] of messages] [(with|as) %bot/string%]").setName("Ban user").setDesc("Ban either a user, a member, or a user by their ID").setExample("command /ban <text>:", "\ttrigger:", "\t\tban arg-1 from guild with id \"622156156316116151\" due to \"Not following discord rules\" as \"Jewel\"");
    }
}

