/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.guild;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

public class EffChannelWithName
extends Effect {
    private Expression<String> name;
    private Expression<Guild> guild;
    private Expression<Object> bot;
    private boolean not;

    protected void execute(Event e) {
        String name = (String)this.name.getSingle(e);
        Guild guild = (Guild)this.guild.getSingle(e);
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        Guild boundGuild = Util.bindGuild(bot, guild);
        if (bot == null || guild == null || name == null || name.isEmpty() || boundGuild == null) {
            return;
        }
        try {
            if (this.not) {
                boundGuild.createTextChannel(name).queue();
                return;
            }
            boundGuild.createVoiceChannel(name).queue();
            return;
        }
        catch (PermissionException x) {
            Vixio.getErrorHandler().needsPerm(bot, x.getPermission().getName(), "create channel");
            return;
        }
    }

    public String toString(Event e, boolean debug) {
        return "create channel named " + this.name.toString(e, debug) + " in " + this.guild.toString(e, debug) + " as " + this.bot.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.guild = exprs[1];
        this.bot = exprs[2];
        this.not = matchedPattern == 0;
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffChannelWithName.class, "create text[(-| )]channel [named] %string% [in %guild%] [(as|with) %bot/string%]", "create voice[(-| )]channel [named] %string% [in %guild%] [(as|with) %bot/string%]").setName("Create channel").setDesc("Create either a voice channel or a text channel as requested.").setExample("discord command $create <text> <text>:", "\ttrigger:", "\t\tif arg-1 contains \"voice\":", "\t\t\tcreate voice channel named arg-2", "\t\t\tstop", "\t\telse if arg-1 contains \"text\":", "\t\t\tcreate text channel named arg-2", "\t\t\tstop", "\t\treply with \"The first argument must either be \"\"text\"\" or \"\"voice\"\"\"");
    }
}

