/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.bot.scope;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.scopes.ScopeMakeBot;
import me.iblitzkriegi.vixio.util.scope.EffectSection;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import org.bukkit.event.Event;

public class EffEnableIntent
extends Effect {
    private Expression<GatewayIntent> gatewayIntent;

    protected void execute(Event e) {
        GatewayIntent gatewayIntent = (GatewayIntent)((Object)this.gatewayIntent.getSingle(e));
        if (gatewayIntent == null) {
            return;
        }
        ScopeMakeBot.jdaBuilder.enableIntents(gatewayIntent, new GatewayIntent[0]);
        switch (gatewayIntent) {
            case GUILD_MEMBERS: {
                ScopeMakeBot.jdaBuilder.setMemberCachePolicy(MemberCachePolicy.ALL);
                break;
            }
            case GUILD_PRESENCES: {
                ScopeMakeBot.jdaBuilder.enableCache(CacheFlag.CLIENT_STATUS, new CacheFlag[0]);
                ScopeMakeBot.jdaBuilder.enableCache(CacheFlag.ACTIVITY, new CacheFlag[0]);
                break;
            }
            case GUILD_VOICE_STATES: {
                ScopeMakeBot.jdaBuilder.enableCache(CacheFlag.VOICE_STATE, new CacheFlag[0]);
                break;
            }
            case GUILD_EMOJIS: {
                ScopeMakeBot.jdaBuilder.enableCache(CacheFlag.EMOTE, new CacheFlag[0]);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "enable the " + this.gatewayIntent.toString() + " intent";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!EffectSection.isCurrentSection(ScopeMakeBot.class)) {
            Skript.warning((String)"The enable intents effect may only be used within the create bot scope");
            return false;
        }
        this.gatewayIntent = exprs[0];
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffEnableIntent.class, "enable [the] %gatewayintent% [gateway] intent [for bot]").setName("Enable Gateway Intent").setDesc("This is used specifically to enable specific gateway intents in the create bot scope.").setExample("discord command neeko:", "\ttrigger:", "\t\tcreate vixio bot:", "\t\t\tenable the guild members intent", "\t\t\tlogin to \"YAHITAMUH\" with the name \"Neeko\"");
    }
}

