/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.time.Instant;
import javax.security.auth.login.LoginException;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.commands.CommandListener;
import me.iblitzkriegi.vixio.events.base.EventListener;
import me.iblitzkriegi.vixio.scopes.ScopeMakeBot;
import me.iblitzkriegi.vixio.util.MessageUpdater;
import me.iblitzkriegi.vixio.util.scope.EffectSection;
import me.iblitzkriegi.vixio.util.skript.AsyncEffect;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class EffLogin
extends AsyncEffect {
    private Expression<String> token;
    private Expression<String> name;
    private boolean scope = false;

    protected void execute(Event e) {
        JDA jda;
        String token = (String)this.token.getSingle(e);
        String name = (String)this.name.getSingle(e);
        if (name == null || token == null || token.isEmpty()) {
            return;
        }
        if (Vixio.getInstance().botNameHashMap.get(name) != null) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Vixio.getInstance(), () -> Vixio.getErrorHandler().warn("Vixio attempted to login to a bot with the name " + name + " but a bot already exists with that name."), 1L);
            return;
        }
        JDABuilder api = this.scope ? ScopeMakeBot.jdaBuilder.setToken(token) : JDABuilder.createDefault(token);
        for (EventListener<?> listener : EventListener.listeners) {
            api.addEventListeners(listener);
        }
        api.addEventListeners(new CommandListener(), new MessageUpdater());
        try {
            jda = api.build().awaitReady();
        }
        catch (InterruptedException | LoginException e1) {
            Vixio.getErrorHandler().warn("Vixio tried to login but encountered \"" + e1.getMessage() + "\"");
            Vixio.getErrorHandler().warn("Maybe your token is wrong?");
            return;
        }
        Bot bot = new Bot(name, jda);
        bot.setLoginTime(Instant.now().getEpochSecond());
        Vixio.getInstance().botHashMap.put(jda, bot);
        Vixio.getInstance().botNameHashMap.put(name, bot);
    }

    public String toString(Event event, boolean b) {
        return "login to discord account with token " + this.token.toString(event, b) + " named " + this.name.toString(event, b);
    }

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.token = expr[0];
        this.name = expr[1];
        this.scope = EffectSection.isCurrentSection(ScopeMakeBot.class);
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffLogin.class, "(login|connect) to %string% (using|with) [the] name %string%").setName("Login").setDesc("Login to a bot account with a token. If you need to enable custom intents, see the create bot scope.").setExample("on skript load:", "\tlogin to \"MjM3MDYyNzE0MTY0MjQ4NTc2.DFfAvg.S_YgY26hqyS1SgNvibrpcdhSk94\" with the name \"VixioButler\"");
    }
}

