/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.commands;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.localization.Language;
import java.util.List;
import me.iblitzkriegi.vixio.commands.DiscordCommand;
import me.iblitzkriegi.vixio.commands.DiscordCommandEvent;
import me.iblitzkriegi.vixio.commands.DiscordCommandFactory;
import me.iblitzkriegi.vixio.commands.Signature;
import me.iblitzkriegi.vixio.util.Util;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CommandListener
extends ListenerAdapter {
    public static MessageReceivedEvent lastCommandEvent;

    @Override
    public void onMessageReceived(MessageReceivedEvent e) {
        if (e.getAuthor().isBot()) {
            return;
        }
        String content = e.getMessage().getContentRaw();
        for (Signature storage : DiscordCommandFactory.getInstance().getCommands()) {
            DiscordCommand command = storage.getCommand();
            for (Expression<String> prefix : command.getPrefixes()) {
                for (String alias : command.getUsableAliases()) {
                    Message message = e.getMessage();
                    TextChannel textChannel = null;
                    Guild guild = null;
                    if (message.isFromGuild()) {
                        textChannel = e.getTextChannel();
                        guild = e.getGuild();
                    }
                    DiscordCommandEvent event = new DiscordCommandEvent(null, alias, command, null, guild, e.getChannel(), textChannel, message, e.getAuthor(), e.getMember(), Util.botFrom(e.getJDA()));
                    String usedCommand = null;
                    String rawPrefix = (String)prefix.getSingle((Event)event);
                    boolean mentions = false;
                    List<User> mentionedUsers = e.getMessage().getMentionedUsers();
                    if (!mentionedUsers.isEmpty() && rawPrefix.contains(mentionedUsers.get(0).getId())) {
                        rawPrefix = rawPrefix.replaceFirst("!", "");
                        mentions = true;
                    }
                    if (rawPrefix.endsWith(" ")) {
                        String suspectedPrefix;
                        String[] spacedCommand = content.split(" ");
                        String string = suspectedPrefix = mentions ? spacedCommand[0].replaceFirst("!", "") : spacedCommand[0];
                        if ((suspectedPrefix + " ").equalsIgnoreCase(rawPrefix)) {
                            usedCommand = rawPrefix + (spacedCommand.length == 1 ? "" : spacedCommand[1]);
                        }
                    } else {
                        String string = usedCommand = mentions ? content.split(" ")[0].replaceFirst("!", "") : content.split(" ")[0];
                    }
                    if (!this.nonNull(usedCommand) || !this.nonNull(rawPrefix) || !usedCommand.equalsIgnoreCase(rawPrefix + alias)) continue;
                    event.setPrefix(rawPrefix);
                    try {
                        event.setArguments(content.substring(usedCommand.length() + 1));
                    }
                    catch (StringIndexOutOfBoundsException e1) {
                        event.setArguments(null);
                    }
                    Util.sync(() -> {
                        lastCommandEvent = e;
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            command.execute(event);
                        }
                    });
                    return;
                }
            }
        }
    }

    public boolean nonNull(String s) {
        if (s == null) {
            return false;
        }
        String localized = Language.get((String)"none");
        if (localized == null) {
            return !s.equals("<none>");
        }
        return !s.equals(localized);
    }
}

