/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudClientIdTracker;
import com.sedmelluq.discord.lavaplayer.tools.http.HttpContextFilter;
import com.sedmelluq.discord.lavaplayer.tools.http.HttpContextRetryCounter;
import java.net.URI;
import java.net.URISyntaxException;
import me.iblitzkriegi.vixio.org.apache.http.HttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpRequestBase;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpUriRequest;
import me.iblitzkriegi.vixio.org.apache.http.client.protocol.HttpClientContext;
import me.iblitzkriegi.vixio.org.apache.http.client.utils.URIBuilder;

public class SoundCloudHttpContextFilter
implements HttpContextFilter {
    private static final HttpContextRetryCounter retryCounter = new HttpContextRetryCounter("sc-id-retry");
    private final SoundCloudClientIdTracker clientIdTracker;

    public SoundCloudHttpContextFilter(SoundCloudClientIdTracker clientIdTracker) {
        this.clientIdTracker = clientIdTracker;
    }

    @Override
    public void onContextOpen(HttpClientContext context) {
    }

    @Override
    public void onContextClose(HttpClientContext context) {
    }

    @Override
    public void onRequest(HttpClientContext context, HttpUriRequest request, boolean isRepetition) {
        retryCounter.handleUpdate(context, isRepetition);
        if (this.clientIdTracker.isIdFetchContext(context)) {
            return;
        }
        if (request.getURI().getHost().contains("sndcdn.com")) {
            return;
        }
        try {
            URI uri = new URIBuilder(request.getURI()).setParameter("client_id", this.clientIdTracker.getClientId()).build();
            if (!(request instanceof HttpRequestBase)) {
                throw new IllegalStateException("Cannot update request URI.");
            }
            ((HttpRequestBase)request).setURI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean onRequestResponse(HttpClientContext context, HttpUriRequest request, HttpResponse response) {
        if (this.clientIdTracker.isIdFetchContext(context) || retryCounter.getRetryCount(context) >= 1) {
            return false;
        }
        if (response.getStatusLine().getStatusCode() == 401) {
            this.clientIdTracker.updateClientId();
            return true;
        }
        return false;
    }

    @Override
    public boolean onRequestException(HttpClientContext context, HttpUriRequest request, Throwable error) {
        return false;
    }
}

