/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter.converter;

import com.sedmelluq.discord.lavaplayer.filter.SplitShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.converter.ConverterAudioFilter;
import java.nio.ShortBuffer;

public class ToSplitShortAudioFilter
extends ConverterAudioFilter {
    private final SplitShortPcmAudioFilter downstream;
    private final int channelCount;
    private final short[][] buffers;

    public ToSplitShortAudioFilter(SplitShortPcmAudioFilter downstream, int channelCount) {
        this.downstream = downstream;
        this.channelCount = channelCount;
        this.buffers = new short[channelCount][];
        for (int i = 0; i < channelCount; ++i) {
            this.buffers[i] = new short[4096];
        }
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        int end = offset + length;
        while (offset < end) {
            int chunkLength = Math.min(end - offset, 4096);
            for (int channel = 0; channel < this.channelCount; ++channel) {
                for (int chunkPosition = 0; chunkPosition < chunkLength; ++chunkPosition) {
                    this.buffers[channel][chunkPosition] = ToSplitShortAudioFilter.floatToShort(input[channel][offset + chunkPosition]);
                }
            }
            this.downstream.process(this.buffers, 0, chunkLength);
        }
    }

    @Override
    public void process(short[] input, int offset, int length) throws InterruptedException {
        int end = offset + length;
        while (end - offset >= this.channelCount) {
            int chunkLength = Math.min(end - offset, 4096 * this.channelCount);
            for (int chunkPosition = 0; chunkPosition < chunkLength; ++chunkPosition) {
                for (int channel = 0; channel < this.buffers.length; ++channel) {
                    this.buffers[channel][chunkPosition] = ToSplitShortAudioFilter.floatToShort(input[offset++]);
                }
            }
            this.downstream.process(this.buffers, 0, chunkLength);
        }
    }

    @Override
    public void process(ShortBuffer buffer) throws InterruptedException {
        while (buffer.hasRemaining()) {
            int chunkLength = Math.min(buffer.remaining(), 4096 * this.channelCount);
            for (int chunkPosition = 0; chunkPosition < chunkLength; ++chunkPosition) {
                for (int channel = 0; channel < this.buffers.length; ++channel) {
                    this.buffers[channel][chunkPosition] = ToSplitShortAudioFilter.floatToShort(buffer.get());
                }
            }
            this.downstream.process(this.buffers, 0, chunkLength);
        }
    }

    @Override
    public void process(short[][] input, int offset, int length) throws InterruptedException {
        this.downstream.process(input, offset, length);
    }
}

