/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.scopes;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.registrations.EventValues;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.scope.EffectSection;
import me.iblitzkriegi.vixio.util.skript.SkriptUtil;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.exceptions.RateLimitedException;
import org.bukkit.event.Event;

public class ScopeMakeEmbed
extends EffectSection {
    public static EmbedBuilder lastEmbed;
    public static Expression<Object> sources;
    public static Expression<Object> bot;
    private Expression<EmbedBuilder> builder;
    private Variable<?> varExpr;
    private VariableString varName;
    private int matchedPattern;

    @Override
    public void execute(Event e) {
        EmbedBuilder embed = this.builder == null ? new EmbedBuilder() : (EmbedBuilder)this.builder.getSingle(e);
        lastEmbed = embed == null ? new EmbedBuilder() : embed;
        this.runSection(e);
        if (this.matchedPattern == 1) {
            Bot bot = Util.botFrom(ScopeMakeEmbed.bot.getSingle(e));
            if (bot == null) {
                return;
            }
            try {
                for (Object source : sources.getArray(e)) {
                    MessageChannel messageChannel = Util.getMessageChannel(bot, source);
                    if (messageChannel == null) continue;
                    if (this.varExpr == null) {
                        messageChannel.sendMessage(embed.build()).queue();
                        continue;
                    }
                    Message resultingMessage = (Message)messageChannel.sendMessage(embed.build()).complete(true);
                    if (resultingMessage == null) continue;
                    Util.storeInVar(this.varName, this.varExpr, UpdatingMessage.from(resultingMessage), e);
                }
            }
            catch (RateLimitedException e1) {
                Vixio.getErrorHandler().cantOpenPrivateChannel();
            }
            catch (PermissionException x) {
                Vixio.getErrorHandler().needsPerm(bot, "send embed", x.getPermission().getName());
            }
        } else if (this.matchedPattern == 2) {
            MessageChannel messageChannel = (MessageChannel)EventValues.getEventValue((Event)e, MessageChannel.class, (int)0);
            Bot bot = (Bot)EventValues.getEventValue((Event)e, Bot.class, (int)0);
            if (bot == null | messageChannel == null) {
                return;
            }
            try {
                MessageChannel boundChannel = Util.bindChannel(bot, messageChannel);
                if (boundChannel == null) {
                    return;
                }
                if (this.varExpr == null) {
                    boundChannel.sendMessage(embed.build()).queue();
                } else {
                    Message resultingMessage = (Message)boundChannel.sendMessage(embed.build()).complete(true);
                    if (resultingMessage != null) {
                        Util.storeInVar(this.varName, this.varExpr, UpdatingMessage.from(resultingMessage), e);
                    }
                }
            }
            catch (PermissionException x) {
                Vixio.getErrorHandler().needsPerm(bot, "send embed", x.getPermission().getName());
            }
            catch (RateLimitedException x) {
                Vixio.getErrorHandler().warn("Vixio attempted to send a embed but got rate limited.");
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "make embed " + this.builder.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (this.checkIfCondition()) {
            return false;
        }
        if (!this.hasSection()) {
            Skript.error((String)"An embed creation scope is useless without any content!");
            return false;
        }
        this.builder = exprs[0];
        this.loadSection(true);
        this.matchedPattern = i;
        if (this.matchedPattern == 1) {
            sources = exprs[1];
            bot = exprs[2];
            if (exprs[3] instanceof Variable) {
                this.varExpr = (Variable)exprs[3];
                this.varName = SkriptUtil.getVariableName(this.varExpr);
            }
        } else if (this.matchedPattern == 2) {
            if (ScriptLoader.getCurrentEvents() != null && Arrays.stream(ScriptLoader.getCurrentEvents()).anyMatch(event -> EventValues.getEventValueGetter((Class)event, MessageChannel.class, (int)0) != null) && Arrays.stream(ScriptLoader.getCurrentEvents()).anyMatch(event -> EventValues.getEventValueGetter((Class)event, Bot.class, (int)0) != null)) {
                if (exprs[1] instanceof Variable) {
                    this.varExpr = (Variable)exprs[1];
                    this.varName = SkriptUtil.getVariableName(this.varExpr);
                }
            } else {
                Skript.error((String)"You can't use reply with in events that do not have a channel and bot to reply with.");
                return false;
            }
        }
        return true;
    }

    static {
        Vixio.getInstance().registerCondition(ScopeMakeEmbed.class, "(make|create) (embed|embed %-embedbuilder%)", "(make|create) (embed|embed %-embedbuilder%) and send [(it|the embed)] to %users/channels% [(with|using) %bot/string%] [and store (it|the message) in %-objects%]", "(make|create) (embed|embed %-embedbuilder%) and reply with [(it|the embed)] [and store (it|the message) in %-objects%]").setName("Make Embed").setDesc("Provides a pretty and easy way of making a new embed with a bunch of different attributes").setExample("command $scope:", "\ttrigger:", "\t\tmake a new embed:", "\t\t\tset color of embed the embed to red", "\t\t\tset url of the embed to \"https://google.com\"", "\t\t\tset title of the embed to \"Google!\"", "\t\tset {_embed} to last made embed");
    }
}

