/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.member;

import ch.njol.skript.classes.Changer;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.changers.ChangeableSimplePropertyExpression;
import me.iblitzkriegi.vixio.changers.EffChange;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

public class ExprNickname
extends ChangeableSimplePropertyExpression<Member, String> {
    public String convert(Member member) {
        return member.getEffectiveName();
    }

    public String getPropertyName() {
        return "discord nickname";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode, boolean vixioChanger) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        Member[] members = (Member[])this.getExpr().getAll(e);
        if (members == null || members.length == 0) {
            return;
        }
        for (Member member : members) {
            Guild boundGuild = Util.bindGuild(bot, member.getGuild());
            if (boundGuild == null) continue;
            try {
                if (mode == Changer.ChangeMode.SET) {
                    if (delta[0] == null || ((String)delta[0]).isEmpty()) {
                        return;
                    }
                    boundGuild.modifyNickname(member, (String)delta[0]).queue();
                    continue;
                }
                boundGuild.modifyNickname(member, null).queue();
            }
            catch (PermissionException x) {
                Vixio.getErrorHandler().needsPerm(bot, EffChange.format(mode, "nickname of", this.getExpr(), bot), x.getPermission().getName());
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "discord nickname of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprNickname.class, String.class, "discord nickname", "members").setName("Nickname of").setDesc("Gets a member's nickname (guild sensitive name). You can set this expression.").setExample("set the discord nickname of event-member to \"new nickname\" with event-bot");
    }
}

