/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.channel;

import ch.njol.skript.classes.Changer;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.changers.ChangeableSimplePropertyExpression;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.requests.restaction.order.RoleOrderAction;
import org.bukkit.event.Event;

public class ExprChannelPosition
extends ChangeableSimplePropertyExpression<Object, Number> {
    protected String getPropertyName() {
        return "discord position";
    }

    public Number convert(Object object) {
        if (object instanceof Role) {
            return ((Role)object).getPosition();
        }
        if (object instanceof GuildChannel) {
            return ((GuildChannel)object).getPosition();
        }
        return null;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode, boolean vixioChanger) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Number.class};
        }
        return null;
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        int position = ((Number)delta[0]).intValue();
        for (Object object : this.getExpr().getAll(e)) {
            if (object instanceof GuildChannel) {
                GuildChannel boundChannel = Util.bindChannel(bot, (GuildChannel)object);
                if (boundChannel == null) continue;
                try {
                    boundChannel.getManager().setPosition(position).queue();
                }
                catch (PermissionException x) {
                    Vixio.getErrorHandler().needsPerm(bot, "set position of channel", x.getPermission().getName());
                }
                continue;
            }
            if (!(object instanceof Role)) continue;
            Role role = (Role)object;
            try {
                Guild guild;
                Guild guild2 = guild = Util.botIsConnected(bot, role.getJDA()) ? role.getGuild() : Util.bindGuild(bot, role.getGuild());
                if (guild == null) continue;
                ((RoleOrderAction)((RoleOrderAction)guild.modifyRolePositions().selectPosition(role)).moveTo(position)).queue();
            }
            catch (PermissionException x) {
                Vixio.getErrorHandler().needsPerm(bot, "set position of role", x.getPermission().getName());
            }
            catch (IllegalStateException x) {
                Vixio.getErrorHandler().warn("Vixio attempted to move a role higher than it may go");
            }
        }
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprChannelPosition.class, Number.class, "discord position", "channels/roles").setName("Position of").setDesc("Get or set the current position of a role or a channel. With channels, 0 is the highest channel, with roles 0 is the lowest custom role, then 1 is the next role up, then 2...").setExample("discord command $pos <text>:", "\ttrigger:", "\t\tset {_vc} to channel with id arg-1", "\t\treply with \"%{_vc}%\"", "\t\treply with \"%discord position of {_vc}%\"");
    }
}

