/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.events;

import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.events.base.BaseEvent;
import me.iblitzkriegi.vixio.events.base.SimpleVixioEvent;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import me.iblitzkriegi.vixio.util.wrapper.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.exceptions.RateLimitedException;

public class EvtAddReaction
extends BaseEvent<MessageReactionAddEvent> {
    @Override
    public BaseEvent.Value[] getValues() {
        return new BaseEvent.Value[]{new BaseEvent.Value(Message.class, e -> {
            try {
                return e.getChannel().retrieveMessageById(e.getMessageId()).complete(true);
            }
            catch (RateLimitedException e1) {
                Vixio.getErrorHandler().warn("Vixio tried to get the message event value for the reaction add event but was rate limited");
                return null;
            }
        })};
    }

    static {
        BaseEvent.register("reaction added", EvtAddReaction.class, ReactionAddEvent.class, "reaction add[ed]").setName("Reaction Add").setDesc("Fired when a reaction is added to a message").setExample("on reaction add:");
        EventValues.registerEventValue(ReactionAddEvent.class, Bot.class, (Getter)new Getter<Bot, ReactionAddEvent>(){

            public Bot get(ReactionAddEvent event) {
                return Util.botFrom(((MessageReactionAddEvent)event.getJDAEvent()).getJDA());
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionAddEvent.class, User.class, (Getter)new Getter<User, ReactionAddEvent>(){

            public User get(ReactionAddEvent event) {
                return ((MessageReactionAddEvent)event.getJDAEvent()).getUser();
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionAddEvent.class, Member.class, (Getter)new Getter<Member, ReactionAddEvent>(){

            public Member get(ReactionAddEvent event) {
                return ((MessageReactionAddEvent)event.getJDAEvent()).getMember();
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionAddEvent.class, Guild.class, (Getter)new Getter<Guild, ReactionAddEvent>(){

            public Guild get(ReactionAddEvent event) {
                return ((MessageReactionAddEvent)event.getJDAEvent()).getGuild();
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionAddEvent.class, UpdatingMessage.class, (Getter)new Getter<UpdatingMessage, ReactionAddEvent>(){

            public UpdatingMessage get(ReactionAddEvent e) {
                return UpdatingMessage.from(e.getValue(Message.class));
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionAddEvent.class, MessageChannel.class, (Getter)new Getter<MessageChannel, ReactionAddEvent>(){

            public MessageChannel get(ReactionAddEvent event) {
                return ((MessageReactionAddEvent)event.getJDAEvent()).getChannel();
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionAddEvent.class, GuildChannel.class, (Getter)new Getter<GuildChannel, ReactionAddEvent>(){

            public GuildChannel get(ReactionAddEvent event) {
                return ((MessageReactionAddEvent)event.getJDAEvent()).getTextChannel();
            }
        }, (int)0);
        EventValues.registerEventValue(ReactionAddEvent.class, Emote.class, (Getter)new Getter<Emote, ReactionAddEvent>(){

            public Emote get(ReactionAddEvent event) {
                MessageReaction.ReactionEmote reactionEmote = ((MessageReactionAddEvent)event.getJDAEvent()).getReactionEmote();
                if (!reactionEmote.isEmote()) {
                    return Util.unicodeFrom(reactionEmote.getName());
                }
                return new Emote(reactionEmote.getEmote());
            }
        }, (int)0);
    }

    public class ReactionAddEvent
    extends SimpleVixioEvent<MessageReactionAddEvent> {
    }
}

