/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.message;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.registrations.EventValues;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.skript.SkriptUtil;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.exceptions.RateLimitedException;
import org.bukkit.event.Event;

public class EffReplyWith
extends Effect {
    private Expression<Object> message;
    private Variable<?> varExpr;
    private VariableString varName;

    protected void execute(Event e) {
        MessageChannel channel = (MessageChannel)EventValues.getEventValue((Event)e, MessageChannel.class, (int)0);
        Bot bot = (Bot)EventValues.getEventValue((Event)e, Bot.class, (int)0);
        if (channel == null || bot == null) {
            return;
        }
        Object[] objects = this.message.getAll(e);
        if (objects == null) {
            return;
        }
        try {
            channel = Util.bindChannel(bot, channel);
            for (Object s : objects) {
                Message message = Util.messageFrom(s);
                if (message == null) continue;
                if (this.varExpr == null) {
                    channel.sendMessage(message).queue();
                    continue;
                }
                try {
                    Message resultingMessage = (Message)channel.sendMessage(message).complete(true);
                    if (resultingMessage == null) continue;
                    Util.storeInVar(this.varName, this.varExpr, UpdatingMessage.from(resultingMessage), e);
                }
                catch (RateLimitedException e1) {
                    Vixio.getErrorHandler().warn("Vixio tried to reply with and store a message but was rate limited");
                }
            }
        }
        catch (PermissionException x) {
            Vixio.getErrorHandler().needsPerm(bot, x.getPermission().getName(), "send message");
        }
    }

    public String toString(Event event, boolean b) {
        return "reply with " + this.message.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (ScriptLoader.getCurrentEvents() != null && Arrays.stream(ScriptLoader.getCurrentEvents()).anyMatch(event -> EventValues.getEventValueGetter((Class)event, MessageChannel.class, (int)0) != null) && Arrays.stream(ScriptLoader.getCurrentEvents()).anyMatch(event -> EventValues.getEventValueGetter((Class)event, Bot.class, (int)0) != null)) {
            this.message = exprs[0];
            if (exprs[1] instanceof Variable) {
                this.varExpr = (Variable)exprs[1];
                this.varName = SkriptUtil.getVariableName(this.varExpr);
            }
            return true;
        }
        Skript.error((String)"You can't use reply with in events that do not have a channel and bot to reply with.");
        return false;
    }

    static {
        Vixio.getInstance().registerEffect(EffReplyWith.class, "reply with %messages/strings% [and store (it|the message) in %-objects%]").setName("Reply with").setDesc("Reply with a message in a event").setExample("reply with \"Hello %mention tag of event-user%\"");
    }
}

