/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.guild.punish;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

public class EffKickUser
extends Effect {
    private Expression<Object> users;
    private Expression<Guild> guild;
    private Expression<Object> bot;
    private Expression<String> reason;

    protected void execute(Event e) {
        Object[] users = this.users.getAll(e);
        Guild guild = (Guild)this.guild.getSingle(e);
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        Guild boundGuild = Util.bindGuild(bot, guild);
        if (bot == null || guild == null || users == null || boundGuild == null) {
            return;
        }
        String kickReason = this.reason == null ? null : (String)this.reason.getSingle(e);
        int n = 0;
        Object[] objectArray = users;
        int n2 = objectArray.length;
        if (n < n2) {
            Object object = objectArray[n];
            String user = object instanceof User ? ((User)object).getId() : (String)object;
            try {
                boundGuild.kick(user, kickReason).queue();
            }
            catch (PermissionException x) {
                Vixio.getErrorHandler().needsPerm(bot, "kick user", x.getPermission().getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return;
        }
    }

    public String toString(Event e, boolean debug) {
        return "kick " + this.users.toString(e, debug) + " from " + this.guild.toString(e, debug) + (this.reason == null ? "" : " due to" + this.reason.toString(e, debug)) + " as " + this.bot.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.users = exprs[0];
        this.guild = exprs[1];
        this.reason = exprs[2];
        this.bot = exprs[3];
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffKickUser.class, "kick %users/strings% from %guild% [(due to|with reason|because of) %-string%] [(with|as) %bot/string%]").setName("Kick user").setDesc("Kick either a user, a member, or a user by their ID").setExample("command /kick <text>:", "\ttrigger:", "\t\tkick arg-1 from guild with id \"622156151\" due to \"Not following discord rules\" as \"Jewel\"");
    }
}

