/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.audio;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.effects.audio.EffPlay;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.audio.GuildMusicManager;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Guild;
import org.apache.commons.lang.StringUtils;
import org.bukkit.event.Event;

public class EffForce
extends Effect {
    private Expression<Object> bot;
    private Expression<Guild> guild;
    private Expression<Object> audio;

    protected void execute(Event e) {
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        Guild guild = (Guild)this.guild.getSingle(e);
        if (guild == null || bot == null) {
            return;
        }
        final GuildMusicManager musicManager = bot.getAudioManager(guild);
        final Object track = this.audio.getSingle(e);
        if (track instanceof AudioTrack) {
            AudioTrack audioTrack = (AudioTrack)track;
            musicManager.scheduler.queue(audioTrack);
            EffPlay.lastLoaded.put(musicManager, audioTrack);
        } else if (track instanceof String && !StringUtils.startsWithIgnoreCase((String)((String)track), (String)"ytsearch:") && !StringUtils.startsWithIgnoreCase((String)((String)track), (String)"scsearch:")) {
            Vixio.getInstance().playerManager.loadItemOrdered(musicManager, (String)track, new AudioLoadResultHandler(){

                @Override
                public void trackLoaded(AudioTrack track2) {
                    musicManager.scheduler.forceTrackToPlay(track2);
                    EffPlay.lastLoaded.put(musicManager, track2);
                }

                @Override
                public void playlistLoaded(AudioPlaylist playlist) {
                }

                @Override
                public void noMatches() {
                    Vixio.getErrorHandler().warn("Vixio attempted to load " + track + " but was unable to find anything.");
                }

                @Override
                public void loadFailed(FriendlyException exception) {
                    Vixio.getErrorHandler().warn("Vixio attempted to load " + track + " but was unable to.");
                }
            });
        }
    }

    public String toString(Event e, boolean debug) {
        return "force " + this.bot.toString(e, debug) + " to play " + this.audio.toString(e, debug) + " in " + this.guild.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.bot = exprs[0];
        this.audio = exprs[1];
        this.guild = exprs[2];
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffForce.class, "force [%bot/string% to] play %string/track% [in %guild%]").setName("Force Play").setDesc("This will force a bot to play a track and set the current playing track to be next in the queue. If the input isn't a single track or not able to be found it will not affect the bot.").setExample("force play \"some youtube url im too lazy to go find one\" in event-guild");
    }
}

