/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetails;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetailsLoader;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import me.iblitzkriegi.vixio.org.apache.http.client.utils.URLEncodedUtils;
import me.iblitzkriegi.vixio.org.apache.http.util.EntityUtils;

public class DefaultYoutubeTrackDetailsLoader
implements YoutubeTrackDetailsLoader {
    @Override
    public YoutubeTrackDetails loadDetails(HttpInterface httpInterface, String videoId) {
        try {
            return this.load(httpInterface, videoId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private YoutubeTrackDetails load(HttpInterface httpInterface, String videoId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 12[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected InfoStatus checkStatusBlock(JsonBrowser statusBlock) {
        if (statusBlock.isNull()) {
            throw new RuntimeException("No playability status block.");
        }
        String status = statusBlock.get("status").text();
        if (status == null) {
            throw new RuntimeException("No playability status field.");
        }
        if ("OK".equals(status)) {
            return InfoStatus.INFO_PRESENT;
        }
        if ("ERROR".equals(status)) {
            String reason = statusBlock.get("reason").text();
            if ("Video unavailable".equals(reason)) {
                return InfoStatus.DOES_NOT_EXIST;
            }
            throw new FriendlyException(reason, FriendlyException.Severity.COMMON, null);
        }
        if ("UNPLAYABLE".equals(status)) {
            String unplayableReason = this.getUnplayableReason(statusBlock);
            throw new FriendlyException(unplayableReason, FriendlyException.Severity.COMMON, null);
        }
        if ("LOGIN_REQUIRED".equals(status)) {
            String errorReason = statusBlock.get("errorScreen").get("playerErrorMessageRenderer").get("reason").get("simpleText").text();
            if ("Private video".equals(errorReason)) {
                throw new FriendlyException("This is a private video.", FriendlyException.Severity.COMMON, null);
            }
            return InfoStatus.REQUIRES_LOGIN;
        }
        throw new FriendlyException("This video cannot be viewed anonymously.", FriendlyException.Severity.COMMON, null);
    }

    protected String getUnplayableReason(JsonBrowser statusBlock) {
        JsonBrowser playerErrorMessage = statusBlock.get("errorScreen").get("playerErrorMessageRenderer");
        String unplayableReason = statusBlock.get("reason").text();
        if (!playerErrorMessage.get("subreason").isNull()) {
            JsonBrowser subreason = playerErrorMessage.get("subreason");
            if (!subreason.get("simpleText").isNull()) {
                unplayableReason = subreason.get("simpleText").text();
            } else if (!subreason.get("runs").isNull() && subreason.get("runs").isList()) {
                StringBuilder reasonBuilder = new StringBuilder();
                subreason.get("runs").values().forEach(item -> reasonBuilder.append(item.get("text").text()).append('\n'));
                unplayableReason = reasonBuilder.toString();
            }
        }
        return unplayableReason;
    }

    protected JsonBrowser getTrackInfoFromEmbedPage(HttpInterface httpInterface, String videoId) throws IOException {
        JsonBrowser basicInfo = this.loadTrackBaseInfoFromEmbedPage(httpInterface, videoId);
        basicInfo.put("args", this.loadTrackArgsFromVideoInfoPage(httpInterface, videoId, basicInfo.get("sts").text()));
        return basicInfo;
    }

    protected JsonBrowser loadTrackBaseInfoFromEmbedPage(HttpInterface httpInterface, String videoId) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com/embed/" + videoId));){
            HttpClientTools.assertSuccessWithContent(response, "embed video page response");
            String html = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            String configJson = DataFormatTools.extractBetween(html, "'PLAYER_CONFIG': ", "});writeEmbed();");
            if (configJson != null) {
                JsonBrowser jsonBrowser = JsonBrowser.parse(configJson);
                return jsonBrowser;
            }
        }
        throw new FriendlyException("Track information is unavailable.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Expected player config is not present in embed page."));
    }

    protected Map<String, String> loadTrackArgsFromVideoInfoPage(HttpInterface httpInterface, String videoId, String sts) throws IOException {
        String videoApiUrl = "https://youtube.googleapis.com/v/" + videoId;
        String encodedApiUrl = URLEncoder.encode(videoApiUrl, StandardCharsets.UTF_8.name());
        String url = "https://www.youtube.com/get_video_info?video_id=" + videoId + "&eurl=" + encodedApiUrl + "hl=en_GB";
        if (sts != null) {
            url = url + "&sts=" + sts;
        }
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(url));){
            HttpClientTools.assertSuccessWithContent(response, "video info response");
            Map<String, String> map = DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(response.getEntity()));
            return map;
        }
    }

    protected static enum InfoStatus {
        INFO_PRESENT,
        REQUIRES_LOGIN,
        DOES_NOT_EXIST;

    }
}

