/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import me.iblitzkriegi.vixio.org.apache.http.client.protocol.HttpClientContext;
import me.iblitzkriegi.vixio.org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundCloudClientIdTracker {
    private static final Logger log = LoggerFactory.getLogger(SoundCloudClientIdTracker.class);
    private static final String ID_FETCH_CONTEXT_ATTRIBUTE = "sc-raw";
    private static final long CLIENT_ID_REFRESH_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    private static final String PAGE_APP_SCRIPT_REGEX = "https://[A-Za-z0-9-.]+/assets/[a-f0-9-]+\\.js";
    private static final String APP_SCRIPT_CLIENT_ID_REGEX = ",client_id:\"([a-zA-Z0-9-_]+)\"";
    private static final Pattern pageAppScriptPattern = Pattern.compile("https://[A-Za-z0-9-.]+/assets/[a-f0-9-]+\\.js");
    private static final Pattern appScriptClientIdPattern = Pattern.compile(",client_id:\"([a-zA-Z0-9-_]+)\"");
    private final Object clientIdLock = new Object();
    private final HttpInterfaceManager httpInterfaceManager;
    private String clientId;
    private long lastClientIdUpdate;

    public SoundCloudClientIdTracker(HttpInterfaceManager httpInterfaceManager) {
        this.httpInterfaceManager = httpInterfaceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientId() {
        Object object = this.clientIdLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (now - this.lastClientIdUpdate < CLIENT_ID_REFRESH_INTERVAL) {
                log.debug("Client ID was recently updated, not updating again right away.");
                return;
            }
            this.lastClientIdUpdate = now;
            log.info("Updating SoundCloud client ID (current is {}).", (Object)this.clientId);
            try {
                this.clientId = this.findClientIdFromSite();
                log.info("Updating SoundCloud client ID succeeded, new ID is {}.", (Object)this.clientId);
            }
            catch (Exception e) {
                log.error("SoundCloud client ID update failed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientId() {
        Object object = this.clientIdLock;
        synchronized (object) {
            if (this.clientId == null) {
                this.updateClientId();
            }
            return this.clientId;
        }
    }

    public boolean isIdFetchContext(HttpClientContext context) {
        return context.getAttribute(ID_FETCH_CONTEXT_ATTRIBUTE) == Boolean.TRUE;
    }

    private String findClientIdFromSite() throws IOException {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            httpInterface.getContext().setAttribute(ID_FETCH_CONTEXT_ATTRIBUTE, true);
            String scriptUrl = this.findApplicationScriptUrl(httpInterface);
            String string = this.findClientIdFromApplicationScript(httpInterface, scriptUrl);
            return string;
        }
    }

    private String findApplicationScriptUrl(HttpInterface httpInterface) throws IOException {
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://soundcloud.com"));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Invalid status code for main page response: " + statusCode);
            }
            String page = EntityUtils.toString(response.getEntity());
            Matcher scriptMatcher = pageAppScriptPattern.matcher(page);
            String result = this.getLastMatchWithinLimit(scriptMatcher, 7);
            if (result != null) {
                String string = result;
                return string;
            }
            try {
                throw new IllegalStateException("Could not find application script from main page.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private String getLastMatchWithinLimit(Matcher m, int limit) {
        String lastMatch = null;
        for (int i = 0; m.find() && i < limit; ++i) {
            lastMatch = m.group();
        }
        return lastMatch;
    }

    private String findClientIdFromApplicationScript(HttpInterface httpInterface, String scriptUrl) throws IOException {
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(scriptUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Invalid status code for application script response: " + statusCode);
            }
            String page = EntityUtils.toString(response.getEntity());
            Matcher clientIdMatcher = appScriptClientIdPattern.matcher(page);
            if (clientIdMatcher.find()) {
                String string = clientIdMatcher.group(1);
                return string;
            }
            try {
                throw new IllegalStateException("Could not find client ID from application script.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

