/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudHtmlDataLoader;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import me.iblitzkriegi.vixio.org.apache.http.util.EntityUtils;

public class DefaultSoundCloudHtmlDataLoader
implements SoundCloudHtmlDataLoader {
    @Override
    public JsonBrowser load(HttpInterface httpInterface, String url) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(url));){
            if (response.getStatusLine().getStatusCode() == 404) {
                JsonBrowser jsonBrowser = JsonBrowser.NULL_BROWSER;
                return jsonBrowser;
            }
            HttpClientTools.assertSuccessWithContent(response, "video page response");
            String html = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            String rootData = this.extractJsonFromHtml(html);
            if (rootData == null) {
                throw new FriendlyException("This url does not appear to be a playable track.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(rootData);
            return jsonBrowser;
        }
    }

    protected String extractJsonFromHtml(String html) {
        return DataFormatTools.extractBetween(html, "catch(t){}})},", ");</script>");
    }
}

