/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.retrieve.channel;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Set;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.VoiceChannel;
import org.bukkit.event.Event;

public class ExprVoiceChannelWithId
extends SimpleExpression<VoiceChannel> {
    private Expression<String> id;
    private Expression<Guild> guild;

    protected VoiceChannel[] get(Event e) {
        String id = (String)this.id.getSingle(e);
        if (id == null || id.isEmpty()) {
            return null;
        }
        if (this.guild != null) {
            Guild guild = (Guild)this.guild.getSingle(e);
            VoiceChannel voiceChannel = guild.getVoiceChannelById(id);
            if (voiceChannel != null) {
                return new VoiceChannel[]{voiceChannel};
            }
            return null;
        }
        Set<JDA> jdaInstances = Vixio.getInstance().botHashMap.keySet();
        if (jdaInstances.isEmpty()) {
            Vixio.getErrorHandler().warn("Vixio attempted to get a voice channel by ID but no Bots were logged in to do so.");
            return null;
        }
        for (JDA jda : jdaInstances) {
            VoiceChannel voiceChannel = jda.getVoiceChannelById(id);
            if (voiceChannel == null) continue;
            return new VoiceChannel[]{voiceChannel};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends VoiceChannel> getReturnType() {
        return VoiceChannel.class;
    }

    public String toString(Event e, boolean debug) {
        return "voice channel with id " + this.id.toString(e, debug) + (this.guild == null ? "" : " in " + this.guild.toString(e, debug));
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.id = exprs[0];
        this.guild = exprs[1];
        return true;
    }

    static {
        Vixio.getInstance().registerExpression(ExprVoiceChannelWithId.class, VoiceChannel.class, ExpressionType.SIMPLE, "voice(-| )channel with id %string% [in %-guild%]").setName("Voice Channel with ID").setDesc("Get a Voice channel by it's ID, can include the Guild it is in for faster results.").setExample("discord command topic <string> <string>:", "\tusage: topic <channel id> <new topic>", "\tprefixes: $", "\ttrigger:", "\t\tset name of voice channel with id arg-1 to arg-2 with event-bot");
    }
}

