/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.message.builder;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.api.MessageBuilder;
import org.bukkit.event.Event;

public class ExprBuilderText
extends SimplePropertyExpression<MessageBuilder, String> {
    private boolean stripped;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.stripped = parseResult.regexes.size() == 1;
        return true;
    }

    protected String getPropertyName() {
        return "[<stripped>] text";
    }

    public String convert(MessageBuilder messageBuilder) {
        try {
            if (this.stripped) {
                return messageBuilder.isEmpty() ? null : messageBuilder.build().getContentStripped();
            }
            return messageBuilder.isEmpty() ? null : messageBuilder.build().getContentRaw();
        }
        catch (IllegalStateException x) {
            Vixio.getErrorHandler().warn("Vixio attempted to build a message with more than 2000 characters.");
            return null;
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        MessageBuilder[] messageBuilders = (MessageBuilder[])this.getExpr().getAll(e);
        switch (mode) {
            case RESET: 
            case REMOVE: {
                for (MessageBuilder messageBuilder : messageBuilders) {
                    messageBuilder.setContent(null);
                }
                break;
            }
            case SET: {
                for (MessageBuilder messageBuilder : messageBuilders) {
                    messageBuilder.setContent((String)delta[0]);
                }
                break;
            }
        }
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "the text of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprBuilderText.class, String.class, "[<stripped>] text", "messagebuilders").setName("Text of a message builder").setDesc("Get the text inside of a message builder. Can be either set, reset, or deleted.").setExample("command /build:", "\ttrigger:", "\t\tset {e} to a new message builder", "\t\tset text of {e} to \"Hey look at this\"", "\t\tbroadcast \"%text of {e}%\"");
    }
}

