/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.member;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.Collection;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.changers.ChangeableSimpleExpression;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.skript.EasyMultiple;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

public class ExprRolesOfMember
extends ChangeableSimpleExpression<Role>
implements EasyMultiple<Member, Role> {
    private Expression<Member> members;

    protected Role[] get(Event e) {
        return (Role[])this.convert(this.getReturnType(), this.members.getAll(e), m -> m.getRoles().toArray(new Role[m.getRoles().size()]));
    }

    public Class<? extends Role> getReturnType() {
        return Role.class;
    }

    public String toString(Event e, boolean debug) {
        return "roles of " + this.members.toString(e, debug);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode, boolean vixioChanger) {
        if (mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE_ALL) {
            return new Class[]{Role[].class};
        }
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.members = exprs[0];
        return true;
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        this.change(this.members.getAll(e), member -> {
            Guild guild = Util.bindGuild(bot, member.getGuild());
            if (guild == null) {
                return;
            }
            try {
                switch (mode) {
                    case RESET: 
                    case DELETE: 
                    case SET: {
                        if (mode != Changer.ChangeMode.SET) break;
                        guild.modifyMemberRoles((Member)member, Util.convertedArray(Role.class, delta)).queue();
                        break;
                    }
                    case ADD: {
                        guild.modifyMemberRoles((Member)member, (Collection<Role>)Arrays.asList(Util.convertedArray(Role.class, delta)), null).queue();
                        break;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        guild.modifyMemberRoles((Member)member, null, (Collection<Role>)Arrays.asList(Util.convertedArray(Role.class, delta))).queue();
                    }
                }
            }
            catch (PermissionException e1) {
                Vixio.getErrorHandler().warn("Vixio encountered a permission exception while trying to change roles");
            }
        });
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprRolesOfMember.class, Role.class, "role", "members").setName("Roles of Member").setDesc("Get the roles that a member has in a guild. You can remove, add and set the roles.").setExample("remove role with id \"6110981981981\" from roles of event-member");
    }
}

