/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.embeds.image;

import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.regex.MatchResult;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.api.entities.MessageEmbed;
import org.bukkit.event.Event;

public class ExprDimension
extends SimplePropertyExpression<Object, Number> {
    private boolean height = false;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        this.height = ((MatchResult)parseResult.regexes.get(0)).group(0).equals("height");
        return true;
    }

    public Number convert(Object image) {
        if (image instanceof MessageEmbed.ImageInfo) {
            MessageEmbed.ImageInfo img = (MessageEmbed.ImageInfo)image;
            return this.height ? img.getHeight() : img.getWidth();
        }
        if (image instanceof MessageEmbed.Thumbnail) {
            MessageEmbed.Thumbnail img = (MessageEmbed.Thumbnail)image;
            return this.height ? img.getHeight() : img.getWidth();
        }
        return null;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "dimension of image";
    }

    public String toString(Event e, boolean debug) {
        return "the " + (this.height ? "height" : "width") + " of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprDimension.class, Number.class, "<width|height>", "thumbnails/imageinfos").setName("Dimension of Image").setDesc("Returns a dimension of an embed's thumbnail, image, footer icon or icon. You can specify either width or height.").setExample("reply with \"%width of {_embed}'s thumbnail%\"");
    }
}

