/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.time.Instant;
import javax.security.auth.login.LoginException;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.commands.CommandListener;
import me.iblitzkriegi.vixio.events.base.EventListener;
import me.iblitzkriegi.vixio.util.MessageUpdater;
import me.iblitzkriegi.vixio.util.skript.AsyncEffect;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.exceptions.AccountTypeException;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class EffLogin
extends AsyncEffect {
    private Expression<String> token;
    private Expression<String> name;

    protected void execute(Event e) {
        JDA api;
        String token = (String)this.token.getSingle(e);
        String name = (String)this.name.getSingle(e);
        if (name == null || token == null || token.isEmpty()) {
            return;
        }
        if (Vixio.getInstance().botNameHashMap.get(name) != null) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Vixio.getInstance(), () -> Vixio.getErrorHandler().warn("Vixio attempted to login to a bot with the name " + name + " but a bot already exists with that name."), 1L);
            return;
        }
        try {
            try {
                api = new JDABuilder(AccountType.BOT).setToken(token).build().awaitReady();
            }
            catch (AccountTypeException x) {
                api = new JDABuilder(AccountType.CLIENT).setToken(token).build().awaitReady();
            }
        }
        catch (InterruptedException | LoginException e1) {
            Vixio.getErrorHandler().warn("Vixio tried to login but encountered \"" + e1.getMessage() + "\"");
            Vixio.getErrorHandler().warn("Maybe your token is wrong?");
            return;
        }
        for (EventListener<?> listener : EventListener.listeners) {
            api.addEventListener(listener);
        }
        api.addEventListener(new CommandListener());
        api.addEventListener(new MessageUpdater());
        Bot bot = new Bot(name, api);
        bot.setLoginTime(Instant.now().getEpochSecond());
        Vixio.getInstance().botHashMap.put(api, bot);
        Vixio.getInstance().botNameHashMap.put(name, bot);
    }

    public String toString(Event event, boolean b) {
        return "login to discord account with token " + this.token.toString(event, b) + " named " + this.name.toString(event, b);
    }

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.token = expr[0];
        this.name = expr[1];
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffLogin.class, "(login|connect) to %string% (using|with) [the] name %string%").setName("Login").setDesc("Login to a bot account with a token").setExample("on skript load:", "\tlogin to \"MjM3MDYyNzE0MTY0MjQ4NTc2.DFfAvg.S_YgY26hqyS1SgNvibrpcdhSk94\" with the name \"VixioButler\"");
    }
}

