/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.DefaultYoutubeTrackDetails;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetails;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetailsLoader;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import me.iblitzkriegi.vixio.org.apache.http.util.EntityUtils;

public class DefaultYoutubeTrackDetailsLoader
implements YoutubeTrackDetailsLoader {
    @Override
    public YoutubeTrackDetails loadDetails(HttpInterface httpInterface, String videoId) {
        try {
            return this.load(httpInterface, videoId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    private YoutubeTrackDetails load(HttpInterface httpInterface, String videoId) throws IOException {
        String url = "https://www.youtube.com/watch?v=" + videoId + "&pbj=1&hl=en";
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(url));){
            Object object;
            JsonBrowser playerInfo;
            block23: {
                int statusCode = response.getStatusLine().getStatusCode();
                if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                    throw new IOException("Invalid status code for video page response: " + statusCode);
                }
                String responseText = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                try {
                    JsonBrowser json = JsonBrowser.parse(responseText);
                    playerInfo = JsonBrowser.NULL_BROWSER;
                    JsonBrowser statusBlock = JsonBrowser.NULL_BROWSER;
                    for (JsonBrowser child : json.values()) {
                        if (!child.isMap()) continue;
                        if (!child.get("player").isNull()) {
                            playerInfo = child.get("player");
                            continue;
                        }
                        if (child.get("playerResponse").isNull()) continue;
                        statusBlock = child.get("playerResponse").get("playabilityStatus");
                    }
                    if (this.checkStatusBlock(statusBlock)) break block23;
                    object = null;
                    return object;
                }
                catch (FriendlyException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new FriendlyException("Received unexpected response from YouTube.", FriendlyException.Severity.SUSPICIOUS, new RuntimeException("Failed to parse: " + responseText, e));
                }
            }
            if (playerInfo.isNull()) {
                throw new RuntimeException("No player info block.");
            }
            object = new DefaultYoutubeTrackDetails(videoId, playerInfo);
            return object;
            {
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private boolean checkStatusBlock(JsonBrowser statusBlock) {
        if (statusBlock.isNull()) {
            throw new RuntimeException("No playability status block.");
        }
        String status = statusBlock.get("status").text();
        if (status == null) {
            throw new RuntimeException("No playability status field.");
        }
        if ("OK".equals(status)) {
            return true;
        }
        if ("ERROR".equals(status)) {
            String reason = statusBlock.get("reason").text();
            if ("Video unavailable".equals(reason)) {
                return false;
            }
            throw new FriendlyException(reason, FriendlyException.Severity.COMMON, null);
        }
        if ("UNPLAYABLE".equals(status) || "LOGIN_REQUIRED".equals(status)) {
            String unplayableReason = this.getUnplayableReason(statusBlock);
            throw new FriendlyException(unplayableReason, FriendlyException.Severity.COMMON, null);
        }
        throw new FriendlyException("This video cannot be viewed anonymously.", FriendlyException.Severity.COMMON, null);
    }

    private String getUnplayableReason(JsonBrowser statusBlock) {
        JsonBrowser playerErrorMessage = statusBlock.get("errorScreen").get("playerErrorMessageRenderer");
        String unplayableReason = statusBlock.get("reason").text();
        if (!playerErrorMessage.get("subreason").isNull()) {
            JsonBrowser subreason = playerErrorMessage.get("subreason");
            if (!subreason.get("simpleText").isNull()) {
                unplayableReason = subreason.get("simpleText").text();
            } else if (!subreason.get("runs").isNull() && subreason.get("runs").isList()) {
                StringBuilder reasonBuilder = new StringBuilder();
                subreason.get("runs").values().forEach(item -> reasonBuilder.append(item.get("text").text()).append('\n'));
                unplayableReason = reasonBuilder.toString();
            }
        }
        return unplayableReason;
    }
}

