/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSignatureResolver;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetails;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import me.iblitzkriegi.vixio.org.apache.http.client.utils.URLEncodedUtils;
import me.iblitzkriegi.vixio.org.apache.http.entity.ContentType;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultYoutubeTrackDetails
implements YoutubeTrackDetails {
    private static final Logger log = LoggerFactory.getLogger(DefaultYoutubeTrackDetails.class);
    private static final String DEFAULT_SIGNATURE_KEY = "signature";
    private final String videoId;
    private final JsonBrowser info;

    public DefaultYoutubeTrackDetails(String videoId, JsonBrowser info) {
        this.videoId = videoId;
        this.info = info;
    }

    @Override
    public AudioTrackInfo getTrackInfo() {
        try {
            return this.loadTrackInfo();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<YoutubeTrackFormat> getFormats(HttpInterface httpInterface, YoutubeSignatureResolver signatureResolver) {
        try {
            return this.loadTrackFormats(httpInterface, signatureResolver);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPlayerScript() {
        return this.info.get("assets").get("js").text();
    }

    private List<YoutubeTrackFormat> loadTrackFormats(HttpInterface httpInterface, YoutubeSignatureResolver signatureResolver) throws Exception {
        String dashUrl;
        JsonBrowser streamingData;
        JsonBrowser args = this.info.get("args");
        String adaptiveFormats = args.get("adaptive_fmts").text();
        if (adaptiveFormats != null) {
            return this.loadTrackFormatsFromAdaptive(adaptiveFormats);
        }
        String playerResponse = args.get("player_response").text();
        if (playerResponse != null && !(streamingData = JsonBrowser.parse(playerResponse).get("streamingData")).isNull()) {
            List<YoutubeTrackFormat> formats = this.loadTrackFormatsFromStreamingData(streamingData.get("formats"));
            formats.addAll(this.loadTrackFormatsFromStreamingData(streamingData.get("adaptiveFormats")));
            if (!formats.isEmpty()) {
                return formats;
            }
        }
        if ((dashUrl = args.get("dashmpd").text()) != null) {
            return this.loadTrackFormatsFromDash(dashUrl, httpInterface, signatureResolver);
        }
        String formatStreamMap = args.get("url_encoded_fmt_stream_map").text();
        if (formatStreamMap != null) {
            return this.loadTrackFormatsFromFormatStreamMap(formatStreamMap);
        }
        log.warn("Video {} with no detected format field, arguments are: {}", (Object)this.videoId, (Object)args.format());
        throw new FriendlyException("Unable to play this YouTube track.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("No adaptive formats, no dash, no stream map."));
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromAdaptive(String adaptiveFormats) throws Exception {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        for (String formatString : adaptiveFormats.split(",")) {
            Map<String, String> format = DefaultYoutubeTrackDetails.decodeUrlEncodedItems(formatString, false);
            tracks.add(new YoutubeTrackFormat(ContentType.parse(format.get("type")), Long.parseLong(format.get("bitrate")), Long.parseLong(format.get("clen")), format.get("url"), format.get("s"), format.getOrDefault("sp", DEFAULT_SIGNATURE_KEY)));
        }
        return tracks;
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromFormatStreamMap(String adaptiveFormats) throws Exception {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        boolean anyFailures = false;
        for (String formatString : adaptiveFormats.split(",")) {
            try {
                Map<String, String> format = DefaultYoutubeTrackDetails.decodeUrlEncodedItems(formatString, false);
                String url = format.get("url");
                if (url == null) continue;
                String contentLength = DataFormatTools.extractBetween(url, "clen=", "&");
                if (contentLength == null) {
                    log.debug("Could not find content length from URL {}, skipping format", (Object)url);
                    continue;
                }
                tracks.add(new YoutubeTrackFormat(ContentType.parse(format.get("type")), this.qualityToBitrateValue(format.get("quality")), Long.parseLong(contentLength), url, format.get("s"), format.getOrDefault("sp", DEFAULT_SIGNATURE_KEY)));
            }
            catch (RuntimeException e) {
                anyFailures = true;
                log.debug("Failed to parse format {}, skipping.", (Object)formatString, (Object)e);
            }
        }
        if (tracks.isEmpty() && anyFailures) {
            log.warn("In adaptive format map {}, all formats either failed to load or were skipped due to missing fields", (Object)adaptiveFormats);
        }
        return tracks;
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromStreamingData(JsonBrowser formats) {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        boolean anyFailures = false;
        if (!formats.isNull() && formats.isList()) {
            for (JsonBrowser formatJson : formats.values()) {
                String cipher = formatJson.get("cipher").text();
                Map cipherInfo = cipher != null ? DefaultYoutubeTrackDetails.decodeUrlEncodedItems(cipher, true) : Collections.emptyMap();
                try {
                    JsonBrowser contentLength = formatJson.get("contentLength");
                    if (contentLength.isNull()) {
                        log.debug("Could not find content length from streamingData format {}, skipping", (Object)formatJson.format());
                        continue;
                    }
                    tracks.add(new YoutubeTrackFormat(ContentType.parse(formatJson.get("mimeType").text()), formatJson.get("bitrate").as(Long.class), contentLength.as(Long.class), cipherInfo.getOrDefault("url", formatJson.get("url").text()), (String)cipherInfo.get("s"), cipherInfo.getOrDefault("sp", DEFAULT_SIGNATURE_KEY)));
                }
                catch (RuntimeException e) {
                    anyFailures = true;
                    log.debug("Failed to parse format {}, skipping", (Object)formatJson, (Object)e);
                }
            }
        }
        if (tracks.isEmpty() && anyFailures) {
            log.warn("In streamingData adaptive formats {}, all formats either failed to load or were skipped due to missing fields", (Object)formats.format());
        }
        return tracks;
    }

    private long qualityToBitrateValue(String quality) {
        if ("small".equals(quality)) {
            return -10L;
        }
        if ("medium".equals(quality)) {
            return -5L;
        }
        if ("hd720".equals(quality)) {
            return -4L;
        }
        return -1L;
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromDash(String dashUrl, HttpInterface httpInterface, YoutubeSignatureResolver signatureResolver) throws Exception {
        String resolvedDashUrl = signatureResolver.resolveDashUrl(httpInterface, this.getPlayerScript(), dashUrl);
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(resolvedDashUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Invalid status code for track info page response: " + statusCode);
            }
            Document document = Jsoup.parse(response.getEntity().getContent(), StandardCharsets.UTF_8.name(), "", Parser.xmlParser());
            List<YoutubeTrackFormat> list = this.loadTrackFormatsFromDashDocument(document);
            return list;
        }
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromDashDocument(Document document) {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        for (Element adaptation : document.select("AdaptationSet")) {
            String mimeType = adaptation.attr("mimeType");
            for (Element representation : adaptation.select("Representation")) {
                String url = representation.select("BaseURL").first().text();
                String contentLength = DataFormatTools.extractBetween(url, "/clen/", "/");
                String contentType = mimeType + "; codecs=" + representation.attr("codecs");
                if (contentLength == null) {
                    log.debug("Skipping format {} because the content length is missing", (Object)contentType);
                    continue;
                }
                tracks.add(new YoutubeTrackFormat(ContentType.parse(contentType), Long.parseLong(representation.attr("bandwidth")), Long.parseLong(contentLength), url, null, DEFAULT_SIGNATURE_KEY));
            }
        }
        return tracks;
    }

    private AudioTrackInfo loadTrackInfo() throws IOException {
        if (this.info == null) {
            return null;
        }
        JsonBrowser args = this.info.get("args");
        boolean useOldFormat = args.get("player_response").isNull();
        if (useOldFormat) {
            if ("fail".equals(args.get("status").text())) {
                throw new FriendlyException(args.get("reason").text(), FriendlyException.Severity.COMMON, null);
            }
            boolean isStream = "1".equals(args.get("live_playback").text());
            long duration = isStream ? Long.MAX_VALUE : args.get("length_seconds").as(Long.class) * 1000L;
            return this.buildTrackInfo(this.videoId, args.get("title").text(), args.get("author").text(), isStream, duration);
        }
        JsonBrowser playerResponse = JsonBrowser.parse(args.get("player_response").text());
        JsonBrowser playabilityStatus = playerResponse.get("playabilityStatus");
        if ("ERROR".equals(playabilityStatus.get("status").text())) {
            throw new FriendlyException(playabilityStatus.get("reason").text(), FriendlyException.Severity.COMMON, null);
        }
        JsonBrowser videoDetails = playerResponse.get("videoDetails");
        boolean isStream = videoDetails.get("isLiveContent").as(Boolean.class);
        long duration = isStream ? Long.MAX_VALUE : videoDetails.get("lengthSeconds").as(Long.class) * 1000L;
        return this.buildTrackInfo(this.videoId, videoDetails.get("title").text(), videoDetails.get("author").text(), isStream, duration);
    }

    private AudioTrackInfo buildTrackInfo(String videoId, String title, String uploader, boolean isStream, long duration) {
        return new AudioTrackInfo(title, uploader, duration, videoId, isStream, "https://www.youtube.com/watch?v=" + videoId);
    }

    private static Map<String, String> decodeUrlEncodedItems(String input, boolean escapedSeparator) {
        if (escapedSeparator) {
            input = input.replace("\\\\u0026", "&");
        }
        return DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(input, StandardCharsets.UTF_8));
    }
}

